/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.config.taglib.impl;

import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.JarURLConnectionUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.URLUtil;
import org.seasar.teeda.core.exception.UriNotFoundRuntimeException;
import org.seasar.teeda.extension.config.taglib.TaglibElementBuilder;
import org.seasar.teeda.extension.config.taglib.TaglibManager;
import org.seasar.teeda.extension.config.taglib.element.TaglibElement;

public abstract class AbstractTaglibManager
implements TaglibManager {
    public static final String INIT_METHOD = "init";
    protected static final String FILE_PROTOCOL = "file:";
    protected static final String JAR_PROTOCOL = "jar:";
    protected static final String JAR_PROTOCOL_SUFFIX = "!/";
    protected static final String JAR_EXTENSION = "jar";
    protected static final String JAR_FILE_SUFFIX = ".jar";
    private Map taglibElements = new HashMap();
    private TaglibElementBuilder builder;

    public void setBuilder(TaglibElementBuilder builder) {
        this.builder = builder;
    }

    public TaglibElement getTaglibElement(String uri) throws UriNotFoundRuntimeException {
        TaglibElement taglibElement = (TaglibElement)this.taglibElements.get(uri);
        if (taglibElement == null) {
            throw new UriNotFoundRuntimeException(uri);
        }
        return taglibElement;
    }

    public boolean hasTaglibElement(String uri) {
        return this.taglibElements.containsKey(uri);
    }

    public void addTaglibElement(TaglibElement taglibElement) {
        this.taglibElements.put(taglibElement.getUri(), taglibElement);
    }

    public abstract void init();

    public void destroy() {
        this.taglibElements.clear();
    }

    protected JarURLConnection openJarURLConnection(URL url) {
        URLConnection conn = URLUtil.openConnection((URL)url);
        if (conn instanceof JarURLConnection) {
            return (JarURLConnection)conn;
        }
        String urlStr = url.toString();
        String ext = ResourceUtil.getExtension((String)urlStr);
        if (ext == null || !ext.equalsIgnoreCase(JAR_EXTENSION)) {
            return null;
        }
        URL jarURL = URLUtil.create((String)(JAR_PROTOCOL + urlStr + JAR_PROTOCOL_SUFFIX));
        return (JarURLConnection)URLUtil.openConnection((URL)jarURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanJar(JarURLConnection conn) {
        conn.setUseCaches(false);
        JarFile jarFile = JarURLConnectionUtil.getJarFile((JarURLConnection)conn);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            Throwable ignore2;
            Object var8_7;
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
            InputStream is = JarFileUtil.getInputStream((JarFile)jarFile, (ZipEntry)entry);
            try {
                this.scanTld(is, name);
                var8_7 = null;
                if (is == null) continue;
            }
            catch (Throwable throwable) {
                var8_7 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable ignore2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (Throwable ignore2) {}
        }
    }

    protected void scanTld(InputStream is, String fileName) {
        this.addTaglibElement(this.builder.build(is, fileName));
    }
}

