/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.FacesConfigOptions;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.context.html.HtmlResponseWriter;
import org.seasar.teeda.core.render.RenderPreparableRenderer;
import org.seasar.teeda.core.scope.impl.DispatchScope;
import org.seasar.teeda.core.scope.impl.DispatchScopeFactory;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.extension.component.UIBody;
import org.seasar.teeda.extension.component.html.THtmlGrid;
import org.seasar.teeda.extension.component.html.THtmlGridBody;
import org.seasar.teeda.extension.component.html.THtmlGridColumn;
import org.seasar.teeda.extension.component.html.THtmlGridColumnGroup;
import org.seasar.teeda.extension.component.html.THtmlGridHeader;
import org.seasar.teeda.extension.component.html.THtmlGridTd;
import org.seasar.teeda.extension.component.html.THtmlGridTh;
import org.seasar.teeda.extension.component.html.THtmlGridTr;
import org.seasar.teeda.extension.helper.GridHelper;
import org.seasar.teeda.extension.render.RendererListener;
import org.seasar.teeda.extension.render.TBodyRenderer;
import org.seasar.teeda.extension.render.TForEachRenderer;
import org.seasar.teeda.extension.util.GridUtil;
import org.seasar.teeda.extension.util.VirtualResource;

public class THtmlGridRenderer
extends TForEachRenderer
implements RenderPreparableRenderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.Grid";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.Grid";
    private static final String GRID_TABLE_CLASS_NAME = "gridTable";
    private static final String GRID_HEADER_CLASS_NAME = "gridHeader";
    private static final String GRID_LEFT_HEADER_CLASS_NAME = "gridLeftHeader";
    private static final String GRID_RIGHT_HEADER_CLASS_NAME = "gridRightHeader";
    private static final String GRID_LEFT_BODY_CLASS_NAME = "gridLeftBody";
    private static final String GRID_RIGHT_BODY_CLASS_NAME = "gridRightBody";
    private static final String GRID_CELL_CLASS_NAME = "gridCell";
    private static final String LEFT_FIXED_CLASS_NAME = "T_leftFixed";
    private static final String LEFT_HEADER = "LeftHeader";
    private static final String LEFT_HEADER_TABLE = "LeftHeaderTable";
    private static final String RIGHT_HEADER = "RightHeader";
    private static final String RIGHT_HEADER_TABLE = "RightHeaderTable";
    private static final String RIGHT_BODY = "RightBody";
    private static final String RIGHT_BODY_TABLE = "RightBodyTable";
    private static final String RIGHT_BODY_SOURCE = "RightBodySource";
    private static final String LEFT_BODY = "LeftBody";
    private static final String LEFT_BODY_TABLE = "LeftBodyTable";
    private static final String LEFT_BODY_SOURCE = "LeftBodySource";
    private static final String GRID_ATTRIBUTE = THtmlGrid.class.getName() + ".GRID_ATTRIBUTE";
    private final IgnoreAttribute thIgnoreAttribute = new IgnoreAttribute();
    private final IgnoreAttribute tdIgnoreAttribute;
    static /* synthetic */ Class class$org$seasar$teeda$extension$helper$GridHelper;

    public THtmlGridRenderer() {
        this.thIgnoreAttribute.addAttributeName("id");
        this.thIgnoreAttribute.addAttributeName("style");
        this.thIgnoreAttribute.addAttributeName("styleClass");
        this.tdIgnoreAttribute = new IgnoreAttribute();
        this.tdIgnoreAttribute.addAttributeName("style");
        this.tdIgnoreAttribute.addAttributeName("styleClass");
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        Iterator it = component.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (child instanceof THtmlGridBody) {
                this.decodeAllRows(context, (THtmlGrid)component, child);
                continue;
            }
            child.processDecodes(context);
        }
    }

    public void encodeBefore(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlGridPrepare(context, (THtmlGrid)component);
    }

    protected void encodeHtmlGridPrepare(FacesContext context, THtmlGrid htmlGrid) throws IOException {
        VirtualResource.addJsResource(context, "org/seasar/teeda/ajax/js/ajax.js");
        String jsPath = ResourceUtil.getResourcePath((String)THtmlGrid.class.getName(), (String)"js");
        VirtualResource.addJsResource(context, jsPath);
        String cssPath = ResourceUtil.getResourcePath((String)THtmlGrid.class.getName(), (String)"css");
        VirtualResource.addCssResource(context, cssPath);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlGridBegin(context, (THtmlGrid)component);
    }

    protected void encodeHtmlGridBegin(FacesContext context, THtmlGrid htmlGrid) throws IOException {
        if (StringUtil.isBlank((String)htmlGrid.getId())) {
            throw new IllegalStateException("THtmlGrid should have 'id' attribute");
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", (UIComponent)htmlGrid);
        RendererUtil.renderIdAttributeIfNecessary((ResponseWriter)writer, (UIComponent)htmlGrid, (String)this.getIdForRender(context, (UIComponent)htmlGrid));
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"border", (Object)"0");
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"cellspacing", (Object)"0");
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"cellpadding", (Object)"0");
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"styleClass", (Object)htmlGrid.getStyleClass());
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"style", (Object)htmlGrid.getStyle());
        this.renderAttributes(writer, htmlGrid);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlGridChildren(context, (THtmlGrid)component);
    }

    protected void encodeHtmlGridChildren(FacesContext context, THtmlGrid htmlGrid) throws IOException {
        UIComponent child;
        ResponseWriter writer = context.getResponseWriter();
        GridAttribute attribute = this.getGridAttribute(context, htmlGrid);
        Iterator it = this.getRenderedChildrenIterator((UIComponent)htmlGrid);
        while (it.hasNext()) {
            child = (UIComponent)it.next();
            if (!(child instanceof THtmlGridHeader)) continue;
            this.encodeGridHeader(context, htmlGrid, (THtmlGridHeader)child, writer, attribute);
            break;
        }
        it = this.getRenderedChildrenIterator((UIComponent)htmlGrid);
        while (it.hasNext()) {
            child = (UIComponent)it.next();
            if (!(child instanceof THtmlGridBody)) continue;
            this.encodeGridBody(context, htmlGrid, (THtmlGridBody)child, writer, attribute);
            break;
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlGridEnd(context, (THtmlGrid)component);
    }

    protected void encodeHtmlGridEnd(FacesContext context, THtmlGrid htmlGrid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("table");
        GridAttribute attribute = this.getGridAttribute(context, htmlGrid);
        this.encodeGridAdjustJavaScript(context, htmlGrid, writer, attribute);
    }

    private void encodeGridAdjustJavaScript(FacesContext context, THtmlGrid htmlGrid, ResponseWriter writer, GridAttribute attribute) throws IOException {
        StringBuffer scriptBody = new StringBuffer(200);
        String id = this.getIdForRender(context, (UIComponent)htmlGrid);
        scriptBody.append("Teeda.THtmlGrid.adjustGridSize('" + id + "');");
        if (attribute.getTableWidth() > 0 && htmlGrid.isScrollHorizontal()) {
            scriptBody.append(" document.getElementById('" + id + RIGHT_HEADER + "').style.width = '" + attribute.getRightHeaderWidth() + "px';");
            scriptBody.append(" document.getElementById('" + id + RIGHT_BODY + "').style.width = '" + attribute.getRightBodyWidth() + "px';");
        }
        this.renderJavaScriptElementOnBodyEnd(context, htmlGrid, scriptBody.toString());
    }

    protected void renderJavaScriptElementOnBodyEnd(FacesContext context, THtmlGrid htmlGrid, String scriptBody) throws IOException {
        if (StringUtil.isBlank((String)scriptBody)) {
            return;
        }
        HtmlResponseWriter writer = new HtmlResponseWriter();
        writer.setWriter((Writer)new StringWriter());
        writer.write("\n");
        writer.startElement("script", null);
        writer.writeAttribute("language", (Object)"JavaScript", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("\n");
        writer.write("<!--");
        writer.write("\n");
        writer.write(scriptBody);
        writer.write("\n");
        writer.write("//-->");
        writer.write("\n");
        writer.endElement("script");
        UIBody body = TBodyRenderer.findParentBody((UIComponent)htmlGrid);
        GridEndRendererListener listener = new GridEndRendererListener(writer);
        TBodyRenderer.addRendererListener(body, listener);
    }

    private void encodeGridHeader(FacesContext context, THtmlGrid htmlGrid, THtmlGridHeader header, ResponseWriter writer, GridAttribute attribute) throws IOException {
        UIComponent child;
        Iterator it;
        writer.startElement("tr", (UIComponent)header);
        writer.startElement("td", (UIComponent)header);
        String id = this.getIdForRender(context, (UIComponent)htmlGrid);
        GridRowContext rowContext = new GridRowContext();
        if (attribute.hasLeftFixCols()) {
            writer.startElement("div", (UIComponent)header);
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"id", (Object)(id + LEFT_HEADER));
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"class", (Object)GRID_LEFT_HEADER_CLASS_NAME);
            writer.startElement("table", (UIComponent)header);
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"id", (Object)(id + LEFT_HEADER_TABLE));
            this.renderInnerTableAttributes(writer);
            writer.startElement("thead", (UIComponent)header);
            it = this.getRenderedChildrenIterator((UIComponent)header);
            while (it.hasNext()) {
                child = (UIComponent)it.next();
                if (!(child instanceof THtmlGridTr)) continue;
                this.encodeGridLeftHeaderTr(context, (THtmlGridTr)child, writer, attribute, rowContext);
            }
            writer.endElement("thead");
            writer.endElement("table");
            writer.endElement("div");
            writer.endElement("td");
            writer.startElement("td", (UIComponent)header);
        }
        writer.startElement("div", (UIComponent)header);
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"id", (Object)(id + RIGHT_HEADER));
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"class", (Object)GRID_RIGHT_HEADER_CLASS_NAME);
        if (htmlGrid.isScrollHorizontal()) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"style", (Object)"overflow:hidden;");
        }
        writer.startElement("table", (UIComponent)header);
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"id", (Object)(id + RIGHT_HEADER_TABLE));
        this.renderInnerTableAttributes(writer);
        rowContext.resetRow();
        writer.startElement("thead", (UIComponent)header);
        it = this.getRenderedChildrenIterator((UIComponent)header);
        while (it.hasNext()) {
            child = (UIComponent)it.next();
            if (!(child instanceof THtmlGridTr)) continue;
            this.encodeGridRightHeaderTr(context, (THtmlGridTr)child, writer, attribute, rowContext);
        }
        writer.endElement("thead");
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
    }

    private void encodeGridLeftHeaderTr(FacesContext context, THtmlGridTr tr, ResponseWriter writer, GridAttribute attribute, GridRowContext rowContext) throws IOException {
        rowContext.nextRow();
        int columnNo = rowContext.getCurrentRowSkipCols();
        if (attribute.getLeftFixCols() <= columnNo) {
            return;
        }
        writer.startElement("tr", (UIComponent)tr);
        Iterator it = this.getRenderedChildrenIterator((UIComponent)tr);
        while (it.hasNext()) {
            int rowspan;
            UIComponent child = (UIComponent)it.next();
            if (child instanceof THtmlGridTh) {
                THtmlGridTh htmlGridTh = (THtmlGridTh)child;
                rowspan = this.getRowspanAsInt(htmlGridTh);
                rowContext.addRowspan(rowspan);
                this.encodeGridHeaderTh(context, htmlGridTh, writer, attribute, ++columnNo);
            } else if (child instanceof THtmlGridTd) {
                THtmlGridTd htmlGridTd = (THtmlGridTd)child;
                rowspan = this.getRowspanAsInt(htmlGridTd);
                rowContext.addRowspan(rowspan);
                this.encodeGridHeaderTd(context, htmlGridTd, writer, attribute, ++columnNo);
            }
            if (attribute.getLeftFixCols() > columnNo) continue;
            break;
        }
        writer.endElement("tr");
    }

    private int getRowspanAsInt(THtmlGridTh th) {
        String s = th.getRowspan();
        if (StringUtil.isNotBlank((String)s)) {
            return Integer.parseInt(s);
        }
        return 1;
    }

    private int getRowspanAsInt(THtmlGridTd td) {
        String s = td.getRowspan();
        if (StringUtil.isNotBlank((String)s)) {
            return Integer.parseInt(s);
        }
        return 1;
    }

    private void encodeGridRightHeaderTr(FacesContext context, THtmlGridTr tr, ResponseWriter writer, GridAttribute attribute, GridRowContext rowContext) throws IOException {
        rowContext.nextRow();
        int columnNo = rowContext.getCurrentRowSkipCols();
        writer.startElement("tr", (UIComponent)tr);
        Iterator it = this.getRenderedChildrenIterator((UIComponent)tr);
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (child instanceof THtmlGridTh) {
                if (++columnNo <= attribute.getLeftFixCols()) continue;
                this.encodeGridHeaderTh(context, (THtmlGridTh)child, writer, attribute, columnNo);
                continue;
            }
            if (!(child instanceof THtmlGridTd) || ++columnNo <= attribute.getLeftFixCols()) continue;
            this.encodeGridHeaderTd(context, (THtmlGridTd)child, writer, attribute, columnNo);
        }
        writer.endElement("tr");
    }

    private void encodeGridHeaderTd(FacesContext context, THtmlGridTd td, ResponseWriter writer, GridAttribute attribute, int columnNo) throws IOException {
        writer.startElement("td", (UIComponent)td);
        writer.startElement("nobr", (UIComponent)td);
        this.encodeDescendantComponent(context, (UIComponent)td);
        writer.endElement("nobr");
        writer.endElement("td");
    }

    private void encodeGridHeaderTh(FacesContext context, THtmlGridTh th, ResponseWriter writer, GridAttribute attribute, int columnNo) throws IOException {
        writer.startElement("th", (UIComponent)th);
        RendererUtil.renderIdAttributeIfNecessary((ResponseWriter)writer, (UIComponent)th, (String)this.getIdForRender(context, (UIComponent)th));
        this.renderRemainAttributes((UIComponent)th, writer, this.thIgnoreAttribute);
        writer.startElement("div", (UIComponent)th);
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"class", (Object)this.createThStyleClassAttribute(th, attribute, columnNo));
        String thStyle = this.createThStyleAttribute(th, attribute, columnNo);
        if (StringUtil.isNotBlank((String)thStyle)) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"style", (Object)thStyle);
        }
        writer.startElement("nobr", (UIComponent)th);
        this.encodeDescendantComponent(context, (UIComponent)th);
        writer.endElement("nobr");
        writer.endElement("div");
        writer.endElement("th");
    }

    private String createThStyleClassAttribute(THtmlGridTh th, GridAttribute attribute, int columnNo) {
        StringBuffer sb = new StringBuffer(50);
        sb.append(GRID_HEADER_CLASS_NAME);
        String styleClass = th.getStyleClass();
        if (StringUtil.isNotBlank((String)styleClass)) {
            sb.append(" ");
            sb.append(styleClass);
        }
        return new String(sb);
    }

    private String createThStyleAttribute(THtmlGridTh th, GridAttribute attribute, int columnNo) {
        String style;
        Integer columnWidth = attribute.getColumnWidth(columnNo);
        StringBuffer sb = new StringBuffer(50);
        if (columnWidth != null) {
            sb.append("width:" + columnWidth + "px;");
        }
        if (StringUtil.isNotBlank((String)(style = th.getStyle()))) {
            sb.append(" ");
            sb.append(style);
        }
        return new String(sb);
    }

    private void encodeGridBody(FacesContext context, THtmlGrid htmlGrid, THtmlGridBody body, ResponseWriter writer, GridAttribute attribute) throws IOException {
        Object item;
        writer.startElement("tr", (UIComponent)body);
        writer.startElement("td", (UIComponent)body);
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"style", (Object)"vertical-align:top;");
        Object page = htmlGrid.getPage(context);
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(page.getClass());
        Object[] items = htmlGrid.getItems(context);
        int firstRenderRowCount = FacesConfigOptions.getGridFirstRenderRowCount();
        int rowSize = firstRenderRowCount > 0 ? Math.min(firstRenderRowCount, items != null ? items.length : 0) : (items != null ? items.length : 0);
        String id = this.getIdForRender(context, (UIComponent)htmlGrid);
        GridRowContext rowContext = null;
        if (attribute.hasLeftFixCols()) {
            writer.startElement("div", (UIComponent)body);
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"id", (Object)(id + LEFT_BODY));
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"class", (Object)GRID_LEFT_BODY_CLASS_NAME);
            if (htmlGrid.isScrollVertical()) {
                RendererUtil.renderAttribute((ResponseWriter)writer, (String)"style", (Object)("overflow:hidden; height:" + attribute.getLeftBodyHeight() + "px;"));
            }
            writer.startElement("table", (UIComponent)body);
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"id", (Object)(id + LEFT_BODY_TABLE));
            this.renderInnerTableAttributes(writer);
            writer.startElement("tbody", (UIComponent)body);
            for (int i = 0; i < rowSize; ++i) {
                item = items[i];
                if (item == null) continue;
                Integer savedIndex = htmlGrid.bindRowIndex(context, new Integer(i));
                Map savedValues = htmlGrid.itemToPage(beanDesc, page, item);
                htmlGrid.enterRow(context, i, (UIComponent)body);
                GridRowContext row = new GridRowContext();
                Iterator it = this.getRenderedChildrenIterator((UIComponent)body);
                while (it.hasNext()) {
                    UIComponent child = (UIComponent)it.next();
                    if (!(child instanceof THtmlGridTr)) continue;
                    this.encodeGridLeftBodyTr(context, (THtmlGridTr)child, writer, attribute, row);
                }
                if (rowContext == null) {
                    rowContext = row;
                }
                htmlGrid.leaveRow(context, (UIComponent)body);
                htmlGrid.pageToItem(page, beanDesc, item, BeanDescFactory.getBeanDesc(item.getClass()), savedValues);
                htmlGrid.bindRowIndex(context, savedIndex);
            }
            writer.endElement("tbody");
            writer.endElement("table");
            writer.endElement("div");
            writer.endElement("td");
            writer.startElement("td", (UIComponent)body);
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"style", (Object)"vertical-align:top;");
        }
        if (rowContext == null) {
            rowContext = new GridRowContext();
        }
        writer.startElement("div", (UIComponent)body);
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"id", (Object)(id + RIGHT_BODY));
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"class", (Object)GRID_RIGHT_BODY_CLASS_NAME);
        if (htmlGrid.isScrollHorizontal() && htmlGrid.isScrollVertical()) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"style", (Object)("overflow:scroll; height:" + attribute.getRightBodyHeight() + "px;"));
            String onscroll = "document.getElementById('" + id + "RightHeader').scrollLeft=this.scrollLeft;";
            if (attribute.hasLeftFixCols()) {
                onscroll = onscroll + " document.getElementById('" + id + "LeftBody').scrollTop=this.scrollTop;";
            }
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"onscroll", (Object)onscroll);
        } else if (htmlGrid.isScrollHorizontal()) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"style", (Object)"overflow-x:scroll;");
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"onscroll", (Object)("document.getElementById('" + id + "RightHeader').scrollLeft=this.scrollLeft;"));
        } else if (htmlGrid.isScrollVertical()) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"style", (Object)("overflow-y:scroll; height:" + attribute.getRightBodyHeight() + "px;"));
            if (attribute.hasLeftFixCols()) {
                RendererUtil.renderAttribute((ResponseWriter)writer, (String)"onscroll", (Object)("document.getElementById('" + id + "LeftBody').scrollTop=this.scrollTop;"));
            }
        }
        writer.startElement("table", (UIComponent)body);
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"id", (Object)(id + RIGHT_BODY_TABLE));
        this.renderInnerTableAttributes(writer);
        writer.startElement("tbody", (UIComponent)body);
        for (int i = 0; i < rowSize; ++i) {
            item = items[i];
            if (item == null) continue;
            Map savedValues = htmlGrid.itemToPage(beanDesc, page, item);
            Integer savedIndex = htmlGrid.bindRowIndex(context, new Integer(i));
            htmlGrid.enterRow(context, i, (UIComponent)body);
            rowContext.resetRow();
            Iterator it = this.getRenderedChildrenIterator((UIComponent)body);
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                if (!(child instanceof THtmlGridTr)) continue;
                this.encodeGridRightBodyTr(context, (THtmlGridTr)child, writer, attribute, rowContext);
            }
            htmlGrid.leaveRow(context, (UIComponent)body);
            htmlGrid.bindRowIndex(context, savedIndex);
            htmlGrid.pageToItem(page, beanDesc, item, BeanDescFactory.getBeanDesc(item.getClass()), savedValues);
        }
        writer.endElement("tbody");
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        if (rowSize < items.length) {
            UIBody uiBody = TBodyRenderer.findParentBody((UIComponent)htmlGrid);
            GridPostRendererListener rendererListener = new GridPostRendererListener();
            rendererListener.attribute = attribute;
            rendererListener.htmlGrid = htmlGrid;
            rendererListener.id = id;
            rendererListener.body = body;
            rendererListener.renderRowLength = rowSize;
            rendererListener.beanDesc = beanDesc;
            rendererListener.page = page;
            rendererListener.items = items;
            TBodyRenderer.addRendererListener(uiBody, rendererListener);
        }
    }

    private void encodeGridLeftBodyTr(FacesContext context, THtmlGridTr tr, ResponseWriter writer, GridAttribute attribute, GridRowContext rowContext) throws IOException {
        rowContext.nextRow();
        int columnNo = rowContext.getCurrentRowSkipCols();
        if (attribute.getLeftFixCols() <= columnNo) {
            return;
        }
        writer.startElement("tr", (UIComponent)tr);
        this.renderStyleClass(tr, writer);
        this.renderStyle(tr, writer);
        Iterator it = this.getRenderedChildrenIterator((UIComponent)tr);
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (child instanceof THtmlGridTd) {
                THtmlGridTd htmlGridTd = (THtmlGridTd)child;
                int rowspan = this.getRowspanAsInt(htmlGridTd);
                rowContext.addRowspan(rowspan);
                this.encodeGridBodyTd(context, htmlGridTd, writer, attribute, ++columnNo);
            }
            if (attribute.getLeftFixCols() > columnNo) continue;
            break;
        }
        writer.endElement("tr");
    }

    private void encodeGridRightBodyTr(FacesContext context, THtmlGridTr tr, ResponseWriter writer, GridAttribute attribute, GridRowContext rowContext) throws IOException {
        rowContext.nextRow();
        int columnNo = rowContext.getCurrentRowSkipCols();
        writer.startElement("tr", (UIComponent)tr);
        this.renderStyleClass(tr, writer);
        this.renderStyle(tr, writer);
        Iterator it = this.getRenderedChildrenIterator((UIComponent)tr);
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (!(child instanceof THtmlGridTd) || ++columnNo <= attribute.getLeftFixCols()) continue;
            this.encodeGridBodyTd(context, (THtmlGridTd)child, writer, attribute, columnNo);
        }
        writer.endElement("tr");
    }

    private void encodeGridBodyTd(FacesContext context, THtmlGridTd td, ResponseWriter writer, GridAttribute attribute, int columnNo) throws IOException {
        writer.startElement("td", (UIComponent)td);
        this.renderRemainAttributes((UIComponent)td, writer, this.tdIgnoreAttribute);
        writer.startElement("div", (UIComponent)td);
        writer.writeAttribute("class", (Object)this.createTdStyleClassAttribute(td), "class");
        String tdStyle = this.createTdStyleAttribute(td, attribute, columnNo);
        if (StringUtil.isNotBlank((String)tdStyle)) {
            writer.writeAttribute("style", (Object)tdStyle, "style");
        }
        writer.startElement("nobr", (UIComponent)td);
        this.encodeDescendantComponent(context, (UIComponent)td);
        writer.endElement("nobr");
        writer.endElement("div");
        writer.endElement("td");
    }

    private String createTdStyleClassAttribute(THtmlGridTd td) {
        String styleClass = td.getStyleClass();
        if (StringUtil.isBlank((String)styleClass)) {
            return GRID_CELL_CLASS_NAME;
        }
        return "gridCell " + styleClass;
    }

    private String createTdStyleAttribute(THtmlGridTd td, GridAttribute attribute, int columnNo) {
        return td.getStyle();
    }

    private GridAttribute getGridAttribute(FacesContext context, THtmlGrid htmlGrid) {
        String key;
        DispatchScope dispatchScope = DispatchScopeFactory.getDispatchScope();
        GridAttribute attribute = (GridAttribute)dispatchScope.get((Object)(key = GRID_ATTRIBUTE + htmlGrid.getClientId(context)));
        if (attribute != null) {
            return attribute;
        }
        attribute = new GridAttribute(context, htmlGrid);
        this.setupTableSize(htmlGrid, attribute);
        this.setupWidth(htmlGrid, attribute);
        this.setupHeight(htmlGrid, attribute);
        dispatchScope.put((Object)key, (Object)attribute);
        return attribute;
    }

    private void setupTableSize(THtmlGrid htmlGrid, GridAttribute attribute) {
        String height;
        String width = htmlGrid.getWidth();
        if (width != null) {
            attribute.setTableWidth(this.toDigit(width));
        }
        if ((height = htmlGrid.getHeight()) != null) {
            attribute.setTableHeight(this.toDigit(height));
        }
    }

    private void setupWidth(THtmlGrid htmlGrid, GridAttribute attribute) {
        int columnNo = 0;
        Iterator itGrid = this.getRenderedChildrenIterator((UIComponent)htmlGrid);
        while (itGrid.hasNext()) {
            UIComponent child = (UIComponent)itGrid.next();
            if (!(child instanceof THtmlGridColumnGroup)) continue;
            THtmlGridColumnGroup columnGroup = (THtmlGridColumnGroup)child;
            Iterator itColGroup = this.getRenderedChildrenIterator((UIComponent)columnGroup);
            while (itColGroup.hasNext()) {
                String widthStr;
                UIComponent element = (UIComponent)itColGroup.next();
                if (!(element instanceof THtmlGridColumn)) continue;
                THtmlGridColumn col = (THtmlGridColumn)element;
                int span = Integer.parseInt(col.getSpan());
                String styleClass = col.getStyleClass();
                if (StringUtil.contains((String)styleClass, (String)LEFT_FIXED_CLASS_NAME)) {
                    attribute.setLeftFixCols(span + attribute.getLeftFixCols());
                }
                if ((widthStr = col.getWidth()) == null) {
                    columnNo += span;
                    continue;
                }
                int width = this.toDigit(widthStr);
                if (StringUtil.contains((String)styleClass, (String)LEFT_FIXED_CLASS_NAME)) {
                    attribute.setLeftWidth(width * span + attribute.getLeftWidth());
                }
                for (int i = 0; i < span; ++i) {
                    attribute.setColumnWidth(++columnNo, new Integer(width));
                }
            }
        }
    }

    private void setupHeight(THtmlGrid htmlGrid, GridAttribute attribute) {
        Iterator itGrid = this.getRenderedChildrenIterator((UIComponent)htmlGrid);
        while (itGrid.hasNext()) {
            UIComponent gridChild = (UIComponent)itGrid.next();
            if (!(gridChild instanceof THtmlGridHeader)) continue;
            Iterator itHeader = this.getRenderedChildrenIterator(gridChild);
            while (itHeader.hasNext()) {
                THtmlGridTr tr;
                String height;
                UIComponent headerChild = (UIComponent)itHeader.next();
                if (!(headerChild instanceof THtmlGridTr) || (height = (tr = (THtmlGridTr)headerChild).getHeight()) == null) continue;
                attribute.setHeaderHeight(this.toDigit(height) + attribute.getHeaderHeight());
            }
        }
    }

    private int toDigit(String s) {
        if (s.toLowerCase().endsWith("px")) {
            s = s.substring(0, s.length() - 2);
        }
        return Integer.parseInt(s);
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void renderInnerTableAttributes(ResponseWriter writer) throws IOException {
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"cellspacing", (Object)"0");
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"cellpadding", (Object)"0");
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"class", (Object)GRID_TABLE_CLASS_NAME);
    }

    private void renderStyleClass(THtmlGridTr tr, ResponseWriter writer) throws IOException {
        String styleClass = tr.getStyleClass();
        if (styleClass != null) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"styleClass", (Object)styleClass);
        }
    }

    private void renderStyle(THtmlGridTr tr, ResponseWriter writer) throws IOException {
        String style = tr.getStyle();
        if (style != null) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"style", (Object)style);
        }
    }

    public void setFirstRenderRowCount(int firstRenderRowCount) {
        FacesConfigOptions.setGridFirstRenderRowCount((int)firstRenderRowCount);
    }

    static class GridRowContext {
        private final Map skipCols = new HashMap();
        private int currentRow = -1;
        private static final Integer ONE = new Integer(1);

        GridRowContext() {
        }

        public void nextRow() {
            ++this.currentRow;
        }

        public void resetRow() {
            this.currentRow = -1;
        }

        public int getCurrentRowSkipCols() {
            Integer i = (Integer)this.skipCols.get(new Integer(this.currentRow));
            if (i != null) {
                return i;
            }
            return 0;
        }

        public void addRowspan(int rowspan) {
            for (int i = 1; i < rowspan; ++i) {
                Integer targetRow = new Integer(this.currentRow + i);
                Integer o = (Integer)this.skipCols.get(targetRow);
                if (o == null) {
                    this.skipCols.put(targetRow, ONE);
                    continue;
                }
                this.skipCols.put(targetRow, new Integer(o + 1));
            }
        }
    }

    class GridEndRendererListener
    implements RendererListener {
        private HtmlResponseWriter partialWriter;

        public GridEndRendererListener(HtmlResponseWriter partialWriter) {
            this.partialWriter = partialWriter;
        }

        public void renderBeforeBodyEnd(FacesContext context) throws IOException {
            ResponseWriter responseWriter = context.getResponseWriter();
            responseWriter.write(this.partialWriter.toString());
        }
    }

    class GridPostRendererListener
    implements RendererListener {
        GridAttribute attribute;
        THtmlGrid htmlGrid;
        String id;
        THtmlGridBody body;
        int renderRowLength;
        BeanDesc beanDesc;
        Object page;
        Object[] items;

        GridPostRendererListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void renderBeforeBodyEnd(FacesContext context) throws IOException {
            String token;
            String s;
            Object item;
            int i;
            GridHelper gridHelper = (GridHelper)SingletonS2ContainerFactory.getContainer().getComponent((Object)(class$org$seasar$teeda$extension$helper$GridHelper == null ? (class$org$seasar$teeda$extension$helper$GridHelper = THtmlGridRenderer.class$("org.seasar.teeda.extension.helper.GridHelper")) : class$org$seasar$teeda$extension$helper$GridHelper));
            GridRowContext rowContext = null;
            StringBuffer script = new StringBuffer(1024);
            HtmlResponseWriter writer = (HtmlResponseWriter)context.getResponseWriter();
            HtmlResponseWriter originalWriter = null;
            ArrayList<String> scriptCallList = null;
            if (this.attribute.hasLeftFixCols()) {
                try {
                    writer.startElement("table", (UIComponent)this.body);
                    RendererUtil.renderAttribute((ResponseWriter)writer, (String)"id", (Object)(this.id + THtmlGridRenderer.LEFT_BODY_SOURCE));
                    RendererUtil.renderAttribute((ResponseWriter)writer, (String)"style", (Object)"display:none;");
                    writer.startElement("tbody", (UIComponent)this.body);
                    if (this.htmlGrid.isAsync()) {
                        originalWriter = writer;
                        writer = this.createNewResponseWriter();
                        context.setResponseWriter((ResponseWriter)writer);
                        scriptCallList = new ArrayList<String>();
                    }
                    for (i = this.renderRowLength; i < this.items.length; ++i) {
                        item = this.items[i];
                        if (item == null) continue;
                        Integer savedIndex = this.htmlGrid.bindRowIndex(context, new Integer(i));
                        Map savedValues = this.htmlGrid.itemToPage(this.beanDesc, this.page, item);
                        this.htmlGrid.enterRow(context, i, (UIComponent)this.body);
                        GridRowContext row = new GridRowContext();
                        Iterator it = THtmlGridRenderer.this.getRenderedChildrenIterator((UIComponent)this.body);
                        while (it.hasNext()) {
                            UIComponent child = (UIComponent)it.next();
                            if (!(child instanceof THtmlGridTr)) continue;
                            THtmlGridRenderer.this.encodeGridLeftBodyTr(context, (THtmlGridTr)child, (ResponseWriter)writer, this.attribute, row);
                        }
                        if (rowContext == null) {
                            rowContext = row;
                        }
                        this.htmlGrid.leaveRow(context, (UIComponent)this.body);
                        this.htmlGrid.pageToItem(this.page, this.beanDesc, item, BeanDescFactory.getBeanDesc(item.getClass()), savedValues);
                        this.htmlGrid.bindRowIndex(context, savedIndex);
                        if (i == 0 || this.items.length % (i + 1) != 0 || !this.htmlGrid.isAsync()) continue;
                        String str = writer.toString();
                        scriptCallList.add(str);
                        writer = this.createNewResponseWriter();
                        context.setResponseWriter((ResponseWriter)writer);
                    }
                    if (this.htmlGrid.isAsync()) {
                        writer = originalWriter;
                    }
                    writer.endElement("tbody");
                    writer.endElement("table");
                    if (this.htmlGrid.isAsync()) {
                        for (i = 0; i < scriptCallList.size(); ++i) {
                            s = (String)scriptCallList.get(i);
                            token = gridHelper.addTable(s);
                            if (i != 0) continue;
                            script.append("ajaxGetTable('" + this.id + THtmlGridRenderer.LEFT_BODY_TABLE + "', " + token + ", " + (this.renderRowLength + 1) + ", " + this.renderRowLength + ");");
                            script.append("\n");
                        }
                    }
                }
                finally {
                    if (originalWriter != null) {
                        context.setResponseWriter((ResponseWriter)originalWriter);
                    }
                }
            }
            if (rowContext == null) {
                rowContext = new GridRowContext();
            }
            writer = originalWriter != null ? originalWriter : (HtmlResponseWriter)context.getResponseWriter();
            try {
                writer.startElement("table", (UIComponent)this.body);
                RendererUtil.renderAttribute((ResponseWriter)writer, (String)"id", (Object)(this.id + THtmlGridRenderer.RIGHT_BODY_SOURCE));
                RendererUtil.renderAttribute((ResponseWriter)writer, (String)"style", (Object)"display:none;");
                writer.startElement("tbody", (UIComponent)this.body);
                if (this.htmlGrid.isAsync()) {
                    originalWriter = writer;
                    writer = this.createNewResponseWriter();
                    context.setResponseWriter((ResponseWriter)writer);
                    scriptCallList = new ArrayList();
                }
                for (i = this.renderRowLength; i < this.items.length; ++i) {
                    item = this.items[i];
                    if (item == null) continue;
                    Map savedValues = this.htmlGrid.itemToPage(this.beanDesc, this.page, item);
                    Integer savedIndex = this.htmlGrid.bindRowIndex(context, new Integer(i));
                    this.htmlGrid.enterRow(context, i, (UIComponent)this.body);
                    rowContext.resetRow();
                    Iterator it = THtmlGridRenderer.this.getRenderedChildrenIterator((UIComponent)this.body);
                    while (it.hasNext()) {
                        UIComponent child = (UIComponent)it.next();
                        if (!(child instanceof THtmlGridTr)) continue;
                        THtmlGridRenderer.this.encodeGridRightBodyTr(context, (THtmlGridTr)child, (ResponseWriter)writer, this.attribute, rowContext);
                    }
                    this.htmlGrid.leaveRow(context, (UIComponent)this.body);
                    this.htmlGrid.bindRowIndex(context, savedIndex);
                    this.htmlGrid.pageToItem(this.page, this.beanDesc, item, BeanDescFactory.getBeanDesc(item.getClass()), savedValues);
                    if (i == 0 || this.items.length % (i + 1) != 0 || !this.htmlGrid.isAsync()) continue;
                    String str = writer.toString();
                    scriptCallList.add(str);
                    writer = this.createNewResponseWriter();
                    context.setResponseWriter((ResponseWriter)writer);
                }
                if (this.htmlGrid.isAsync()) {
                    writer = originalWriter;
                }
                writer.endElement("tbody");
                writer.endElement("table");
                if (this.htmlGrid.isAsync()) {
                    for (i = 0; i < scriptCallList.size(); ++i) {
                        s = (String)scriptCallList.get(i);
                        token = gridHelper.addTable(s);
                        if (i != 0) continue;
                        script.append("ajaxGetTable('" + this.id + THtmlGridRenderer.RIGHT_BODY_TABLE + "', " + token + ", " + (this.renderRowLength + 1) + ", " + this.renderRowLength + ");");
                        script.append("\n");
                    }
                    String callback = this.htmlGrid.getCallback();
                    StringBuffer ajaxGetTableScript = callback != null ? this.makeAjaxGetTableScript(callback) : this.makeAjaxGetTableScript();
                    ajaxGetTableScript.append(script);
                    THtmlGridRenderer.this.renderJavaScriptElement((ResponseWriter)writer, ajaxGetTableScript.toString());
                } else {
                    THtmlGridRenderer.this.renderJavaScriptElement((ResponseWriter)writer, "Teeda.THtmlGrid.loadGridRows('" + this.id + "');");
                }
            }
            finally {
                if (originalWriter != null) {
                    context.setResponseWriter((ResponseWriter)originalWriter);
                }
            }
        }

        protected HtmlResponseWriter createNewResponseWriter() {
            HtmlResponseWriter writer = new HtmlResponseWriter();
            writer.setWriter((Writer)new StringWriter(1024 * this.renderRowLength));
            return writer;
        }

        protected StringBuffer makeAjaxGetTableScript() {
            StringBuffer buf = new StringBuffer(255);
            buf.append("function ajaxGetTable(destId, token, firstNum, range) {\nvar _token = token;\nvar f = function teedaGridHelper_ajaxGetTable(table) {\n  if(table == 'null' || !table || table == ''){\n    return;\n  }\n  var dummy = document.createElement('div');\n  dummy.innerHTML = '<table><tbody>' + table + '</tbody></table>';\n  var dest = document.getElementById(destId);\n  dest.appendChild(dummy.getElementsByTagName('tbody')[0]);\n  _token = _token + 1;\n  ajaxGetTable(destId, _token, firstNum, range);\n};\nKumu.Ajax.executeTeedaAjax(f, [token], Kumu.Ajax.RESPONSE_TYPE_HTML);}");
            buf.append("\n");
            return buf;
        }

        protected StringBuffer makeAjaxGetTableScript(String callback) {
            String callbackPrefix = callback.substring(0, callback.lastIndexOf("("));
            StringBuffer buf = new StringBuffer(255);
            buf.append("function ajaxGetTable(destId, token, firstNum, range) {\nvar _token = token;\nvar f = function teedaGridHelper_ajaxGetTable(table) {\n  if(table == 'null' || !table || table == ''){\n    return;\n  }\n  var dummy = document.createElement('div');\n  dummy.innerHTML = '<table><tbody>' + table + '</tbody></table>';\n  var dest = document.getElementById(destId);\n  var o = dummy.getElementsByTagName('tbody')[0];\n  var lastNum = firstNum + range;\n" + callbackPrefix + "( destId, firstNum, lastNum, o);\n" + "  dest.appendChild(o);\n" + "  _token = _token + 1;\n" + "  firstNum = lastNum;\n" + "  ajaxGetTable(destId, _token, firstNum, range);\n" + "};\n" + "Kumu.Ajax.executeTeedaAjax(f, [token], Kumu.Ajax.RESPONSE_TYPE_HTML);}");
            buf.append("\n");
            return buf;
        }
    }

    private static class GridAttribute
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int scrollBarWidth;
        private int tableWidth;
        private int tableHeight;
        private int headerHeight;
        private int leftFixCols;
        private final Map columnWidths = new HashMap();
        private THtmlGrid htmlGrid;
        private int leftWidth;

        public GridAttribute(FacesContext context, THtmlGrid htmlGrid) {
            this.htmlGrid = htmlGrid;
            this.scrollBarWidth = GridUtil.getScrollBarWidthByOS(context);
        }

        public Integer getColumnWidth(int no) {
            return (Integer)this.columnWidths.get(new Integer(no));
        }

        public void setColumnWidth(int no, Integer width) {
            this.columnWidths.put(new Integer(no), width);
        }

        public boolean hasLeftFixCols() {
            return 0 < this.leftFixCols;
        }

        public int getHeaderHeight() {
            return this.headerHeight;
        }

        public void setHeaderHeight(int headerHeight) {
            this.headerHeight = headerHeight;
        }

        public int getLeftBodyHeight() {
            if (this.htmlGrid.isScrollHorizontal()) {
                return this.tableHeight - this.headerHeight - this.scrollBarWidth;
            }
            return this.tableHeight - this.headerHeight;
        }

        public int getLeftFixCols() {
            return this.leftFixCols;
        }

        public void setLeftFixCols(int leftFixCols) {
            this.leftFixCols = leftFixCols;
        }

        public int getLeftWidth() {
            return this.leftWidth;
        }

        public void setLeftWidth(int leftWidth) {
            this.leftWidth = leftWidth;
        }

        public int getRightBodyHeight() {
            return this.tableHeight - this.headerHeight;
        }

        public int getRightBodyWidth() {
            return this.tableWidth - this.leftWidth;
        }

        public int getRightHeaderWidth() {
            if (this.htmlGrid.isScrollVertical()) {
                return this.tableWidth - this.leftWidth - this.scrollBarWidth;
            }
            return this.tableWidth - this.leftWidth;
        }

        public int getScrollBarWidth() {
            return this.scrollBarWidth;
        }

        public void setScrollBarWidth(int scrollBarWidth) {
            this.scrollBarWidth = scrollBarWidth;
        }

        public int getTableHeight() {
            return this.tableHeight;
        }

        public void setTableHeight(int tableHeight) {
            this.tableHeight = tableHeight;
        }

        public int getTableWidth() {
            return this.tableWidth;
        }

        public void setTableWidth(int tableWidth) {
            this.tableWidth = tableWidth;
        }
    }
}

