/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassLoaderUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.URLUtil;
import org.seasar.framework.xml.SaxHandlerParser;
import org.seasar.teeda.core.config.faces.AbstractFacesConfigurator;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.faces.impl.FacesConfigUtil;
import org.seasar.teeda.core.util.IteratorUtil;

public class MetaInfFacesConfigurator
extends AbstractFacesConfigurator {
    private static final Logger logger_ = Logger.getLogger((Class)MetaInfFacesConfigurator.class);
    private String path_ = "/WEB-INF/lib/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FacesConfig configure() {
        String path = this.getPath();
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("target file path = " + path));
        }
        SaxHandlerParser parser = this.createSaxHandlerParser();
        ArrayList<FacesConfig> list = new ArrayList<FacesConfig>();
        ClassLoader loader = ClassLoaderUtil.getClassLoader(this.getClass());
        Iterator itr = IteratorUtil.getResourcesIterator(loader, "META-INF/faces-config.xml");
        while (itr.hasNext()) {
            URL url = (URL)itr.next();
            if (url.toExternalForm().indexOf(path) == -1) continue;
            InputStream is = URLUtil.openStream((URL)url);
            try {
                FacesConfig config = (FacesConfig)parser.parse(is, url.toExternalForm());
                list.add(config);
            }
            finally {
                InputStreamUtil.close((InputStream)is);
            }
        }
        return FacesConfigUtil.collectAllFacesConfig(list);
    }

    public String getPath() {
        return this.path_;
    }

    public void setPath(String path) {
        this.path_ = path;
    }
}

