/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import java.util.ArrayList;
import java.util.List;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.autoregister.ClassPattern;

public abstract class AbstractAutoRegister {
    public static final String INIT_METHOD = "registerAll";
    private S2Container container;
    private List classPatterns = new ArrayList();
    private List ignoreClassPatterns = new ArrayList();

    public S2Container getContainer() {
        return this.container;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public int getClassPatternSize() {
        return this.classPatterns.size();
    }

    public ClassPattern getClassPattern(int index) {
        return (ClassPattern)this.classPatterns.get(index);
    }

    public void addClassPattern(String packageName, String shortClassNames) {
        this.addClassPattern(new ClassPattern(packageName, shortClassNames));
    }

    public void addClassPattern(ClassPattern classPattern) {
        this.classPatterns.add(classPattern);
    }

    public void addIgnoreClassPattern(String packageName, String shortClassNames) {
        this.addIgnoreClassPattern(new ClassPattern(packageName, shortClassNames));
    }

    public void addIgnoreClassPattern(ClassPattern classPattern) {
        this.ignoreClassPatterns.add(classPattern);
    }

    public abstract void registerAll();

    protected boolean hasComponentDef(String name) {
        return this.findComponentDef(name) != null;
    }

    protected ComponentDef findComponentDef(String name) {
        if (name == null) {
            return null;
        }
        S2Container container = this.getContainer();
        for (int i = 0; i < container.getComponentDefSize(); ++i) {
            ComponentDef cd = container.getComponentDef(i);
            if (!name.equals(cd.getComponentName())) continue;
            return cd;
        }
        return null;
    }

    protected boolean isIgnore(String packageName, String shortClassName) {
        if (this.ignoreClassPatterns.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.ignoreClassPatterns.size(); ++i) {
            ClassPattern cp = (ClassPattern)this.ignoreClassPatterns.get(i);
            if (!cp.isAppliedPackageName(packageName) || !cp.isAppliedShortClassName(shortClassName)) continue;
            return true;
        }
        return false;
    }
}

