/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.Tag;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.html.ElementProcessor;
import org.seasar.teeda.extension.html.TagProcessor;
import org.seasar.teeda.extension.html.processor.TextProcessorImpl;

public class ElementProcessorImpl
implements ElementProcessor {
    private Class tagClass;
    private Map properties;
    private final List children = new ArrayList();
    private StringBuffer buffer;

    public ElementProcessorImpl(Class tagClass, Map properties) {
        this.tagClass = tagClass;
        this.properties = properties;
        this.initializeBuffer();
    }

    protected void initializeBuffer() {
        this.buffer = new StringBuffer(256);
    }

    public Class getTagClass() {
        return this.tagClass;
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public Iterator getPropertyNameIterator() {
        return this.properties.keySet().iterator();
    }

    public int getChildSize() {
        return this.children.size();
    }

    public TagProcessor getChild(int index) {
        return (TagProcessor)this.children.get(index);
    }

    protected void addChild(TagProcessor child) {
        this.children.add(child);
    }

    public void addElement(ElementProcessor processor) {
        this.processText();
        this.addChild(processor);
    }

    public void addText(String text) {
        this.buffer.append(text);
    }

    protected void processText() {
        if (this.buffer.length() > 0) {
            this.addChild(new TextProcessorImpl(this.buffer.toString()));
            this.initializeBuffer();
        }
    }

    public void endElement() {
        this.processText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(PageContext pageContext, Tag parentTag) throws JspException {
        Tag tag = (Tag)ClassUtil.newInstance((Class)this.tagClass);
        try {
            this.process(pageContext, tag, parentTag);
        }
        finally {
            tag.release();
        }
    }

    protected void process(PageContext pageContext, Tag tag, Tag parentTag) throws JspException {
        if (parentTag != null) {
            tag.setParent(parentTag);
        }
        tag.setPageContext(pageContext);
        this.setupProperties(tag);
        if (tag instanceof BodyTag) {
            this.processBodyTag(pageContext, (BodyTag)tag);
        } else if (tag instanceof IterationTag) {
            this.processIterationTag(pageContext, (IterationTag)tag);
        } else {
            this.processTag(pageContext, tag);
        }
    }

    protected void processTag(PageContext pageContext, Tag tag) throws JspException {
        if (0 != tag.doStartTag()) {
            this.processChildren(pageContext, tag);
            tag.doEndTag();
        }
    }

    protected void processBodyTag(PageContext pageContext, BodyTag tag) throws JspException {
        int evalDoStartTag = tag.doStartTag();
        if (0 != evalDoStartTag) {
            BodyContent bodyContent = null;
            if (1 != evalDoStartTag) {
                bodyContent = pageContext.pushBody();
                tag.setBodyContent(bodyContent);
                tag.doInitBody();
            }
            do {
                this.processChildren(pageContext, (Tag)tag);
            } while (2 == tag.doAfterBody());
            if (bodyContent != null) {
                pageContext.popBody();
            }
        }
        tag.doEndTag();
    }

    protected void processIterationTag(PageContext pageContext, IterationTag tag) throws JspException {
        int evalDoStartTag = tag.doStartTag();
        if (0 != evalDoStartTag) {
            do {
                this.processChildren(pageContext, (Tag)tag);
            } while (2 == tag.doAfterBody());
        }
        tag.doEndTag();
    }

    protected void processChildren(PageContext pageContext, Tag parentTag) throws JspException {
        for (int i = 0; i < this.getChildSize(); ++i) {
            TagProcessor child = this.getChild(i);
            child.process(pageContext, parentTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void composeComponentTree(FacesContext context, PageContext pageContext, Tag parentTag) throws JspException {
        Tag tag = (Tag)ClassUtil.newInstance((Class)this.tagClass);
        try {
            if (tag instanceof UIComponentTag) {
                UIComponentTag componentTag = (UIComponentTag)tag;
                this.composeComponentTree(context, pageContext, componentTag, parentTag);
            } else {
                this.setUpTag(context, pageContext, tag, parentTag);
            }
        }
        finally {
            tag.release();
        }
    }

    protected void setUpTag(FacesContext context, PageContext pageContext, Tag tag, Tag parentTag) throws JspException {
        if (parentTag != null) {
            tag.setParent(parentTag);
        }
        tag.setPageContext(pageContext);
        this.setupProperties(tag);
        this.composeComponentTreeChildren(context, pageContext, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void composeComponentTree(FacesContext context, PageContext pageContext, UIComponentTag tag, Tag parentTag) throws JspException {
        if (parentTag != null) {
            tag.setParent(parentTag);
        }
        tag.setPageContext(pageContext);
        Map ignoredProps = this.setupProperties((Tag)tag);
        tag.setupFacesContext();
        UIComponent component = tag.findComponent(context);
        component.getAttributes().putAll(ignoredProps);
        tag.pushUIComponentTag();
        try {
            this.composeComponentTreeChildren(context, pageContext, (Tag)tag);
        }
        finally {
            tag.popUIComponentTag();
        }
    }

    protected void composeComponentTreeChildren(FacesContext context, PageContext pageContext, Tag parentTag) throws JspException {
        for (int i = 0; i < this.getChildSize(); ++i) {
            TagProcessor child = this.getChild(i);
            child.composeComponentTree(context, pageContext, parentTag);
        }
    }

    protected Map setupProperties(Tag tag) {
        HashMap<String, String> ignoredProperties = new HashMap<String, String>();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(tag.getClass());
        Iterator i = this.getPropertyNameIterator();
        while (i.hasNext()) {
            String propertyName = (String)i.next();
            String value = this.getProperty(propertyName);
            if (StringUtil.isEmpty((String)value)) continue;
            if (beanDesc.hasPropertyDesc(propertyName)) {
                PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
                if (!pd.isWritable()) continue;
                pd.setValue((Object)tag, (Object)value);
                continue;
            }
            ignoredProperties.put(propertyName, value);
        }
        return ignoredProperties;
    }
}

