/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Iterator;
import java.util.Map;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.ElementProcessor;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;
import org.seasar.teeda.extension.html.processor.GenericElementProcessor;

public class GenericElementFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "element";

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        String id = elementNode.getProperty("id");
        if (pageDesc == null) {
            return false;
        }
        if (id == null) {
            return false;
        }
        int pos = id.indexOf(45);
        if (pos > -1) {
            id = id.substring(0, pos) + StringUtil.capitalize((String)id.substring(pos + 1));
        }
        Iterator i = elementNode.getPropertyNameIterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if ("id".equalsIgnoreCase(key)) continue;
            String propName = id + StringUtil.capitalize((String)key);
            if (pageDesc.hasDynamicProperty(propName)) {
                return true;
            }
            if ("class".equals(key) && pageDesc.hasDynamicProperty(propName = id + StringUtil.capitalize((String)"styleClass"))) {
                return true;
            }
            String value = elementNode.getProperty(key);
            if (value == null || !value.endsWith("Label")) continue;
            return true;
        }
        return false;
    }

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }

    protected ElementProcessor createProcessor(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc, String uri, String tagName) {
        Class tagClass = this.getTagClass(uri, tagName);
        Map props = this.createProperties(elementNode, pageDesc, actionDesc);
        GenericElementProcessor processor = new GenericElementProcessor(tagClass, props, elementNode.getTagName());
        this.customizeProcessor(processor, elementNode, pageDesc, actionDesc);
        return processor;
    }
}

