/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.HashMap;
import java.util.Map;
import javax.faces.internal.ValidatorBuilder;
import javax.faces.internal.ValidatorChain;
import javax.faces.internal.ValidatorResource;
import javax.faces.validator.Validator;
import org.seasar.framework.beans.util.BeanUtil;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class NormalValidatorBuilderImpl
implements ValidatorBuilder {
    private S2Container container;
    private Map validators = new HashMap();

    public NormalValidatorBuilderImpl() {
        this.container = SingletonS2ContainerFactory.getContainer();
    }

    public NormalValidatorBuilderImpl(S2Container container) {
        this.container = container;
    }

    public Validator build(String expression, ValidatorResource.ValidatorPair[] pairs) {
        if (pairs == null || pairs.length == 0) {
            return null;
        }
        if (this.validators.containsKey(expression)) {
            return (Validator)this.validators.get(expression);
        }
        if (pairs.length == 1) {
            Validator validator = this.getSingleValidator(pairs[0]);
            this.validators.put(expression, validator);
            return validator;
        }
        ValidatorChain chain = new ValidatorChain();
        for (int i = 0; i < pairs.length; ++i) {
            chain.add(this.getSingleValidator(pairs[i]));
        }
        this.validators.put(expression, chain);
        return chain;
    }

    protected Validator getSingleValidator(ValidatorResource.ValidatorPair pair) {
        Validator validator = (Validator)this.container.getComponent((Object)pair.validatorName);
        BeanUtil.copyProperties((Map)pair.properties, (Object)validator);
        return validator;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public void clearAll() {
        this.validators.clear();
    }

    public void clearValidator(String expression) {
        this.validators.remove(expression);
    }
}

