/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.util;

import org.seasar.teeda.extension.component.TreeNode;
import org.seasar.teeda.extension.component.html.THtmlTree;
import org.seasar.teeda.extension.util.TreeNavigationImageLocator;

public class TreeNavigationImageLocatorImpl
implements TreeNavigationImageLocator {
    private static final String LINE_TRUNK_GIF = "line-trunk.gif";
    public static final String imageRoot_BINDING = "bindingType=may";
    private String imageRoot = "";
    private static final String NAV_MINUS_LINE_LAST_GIF = "nav-line-last-expand.gif";
    private static final String NAV_PLUS_LINE_LAST_GIF = "nav-line-last-collapse.gif";
    private static final String NAV_MINUS_LINE_MIDDLE_GIF = "nav-line-middle-expand.gif";
    private static final String NAV_PLUS_LINE_MIDDLE_GIF = "nav-line-middle-collapse.gif";
    private static final String NAV_MINUS_GIF = "nav-expand.gif";
    private static final String NAV_PLUS_GIF = "nav-collapse.gif";
    private static final String LINE_LAST_GIF = "line-last.gif";
    private static final String LINE_MIDDLE_GIF = "line-middle.gif";
    private static final String SPACER_GIF = "spacer.gif";
    private static final int NOTHING = 0;
    private static final int CHILDREN = 1;
    private static final int EXPANDED = 2;
    private static final int LINES = 4;
    private static final int LAST = 8;
    private String navSrc;
    private String altSrc;
    private boolean renderLineBackground = false;
    private boolean clickable = false;

    public void setUpImageLocation(THtmlTree tree) {
        TreeNode node = tree.getNode();
        String nodeId = tree.getNodeId();
        boolean showLines = tree.isShowLines();
        int bitMask = 0;
        if (!node.isLeaf()) {
            ++bitMask;
        }
        if (bitMask == 1 && tree.isNodeExpanded()) {
            bitMask += 2;
        }
        if (tree.isLastChild(nodeId)) {
            bitMask += 8;
        }
        if (showLines) {
            bitMask += 4;
        }
        switch (bitMask) {
            case 0: 
            case 8: {
                this.navSrc = SPACER_GIF;
                this.setClickable(false);
                break;
            }
            case 4: {
                this.navSrc = LINE_MIDDLE_GIF;
                this.setClickable(false);
                break;
            }
            case 12: {
                this.navSrc = LINE_LAST_GIF;
                this.setClickable(false);
                break;
            }
            case 1: 
            case 9: {
                this.navSrc = NAV_PLUS_GIF;
                this.altSrc = NAV_MINUS_GIF;
                this.setClickable(true);
                break;
            }
            case 5: {
                this.navSrc = NAV_PLUS_LINE_MIDDLE_GIF;
                this.altSrc = NAV_MINUS_LINE_MIDDLE_GIF;
                this.setClickable(true);
                break;
            }
            case 13: {
                this.navSrc = NAV_PLUS_LINE_LAST_GIF;
                this.altSrc = NAV_MINUS_LINE_LAST_GIF;
                this.setClickable(true);
                break;
            }
            case 3: 
            case 11: {
                this.navSrc = NAV_MINUS_GIF;
                this.altSrc = NAV_PLUS_GIF;
                this.setClickable(true);
                break;
            }
            case 7: {
                this.navSrc = NAV_MINUS_LINE_MIDDLE_GIF;
                this.altSrc = NAV_PLUS_LINE_MIDDLE_GIF;
                this.setClickable(true);
                break;
            }
            case 15: {
                this.navSrc = NAV_MINUS_LINE_LAST_GIF;
                this.altSrc = NAV_PLUS_LINE_LAST_GIF;
                this.setClickable(true);
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                throw new IllegalStateException("Encountered a node [" + nodeId + "] + with an illogical state.  " + "Node is expanded but it is also considered a leaf (a leaf cannot be considered expanded.");
            }
            default: {
                throw new IllegalArgumentException("Invalid argument");
            }
        }
        if (this.navSrc != null) {
            this.navSrc = this.imageRoot + this.navSrc;
        }
        if (this.altSrc != null) {
            this.altSrc = this.imageRoot + this.altSrc;
        }
        this.renderLineBackground = (bitMask & 4) != 0 && (bitMask & 8) == 0;
    }

    public boolean shouldRenderLineBackground() {
        return this.renderLineBackground;
    }

    public String getAltSrc() {
        return this.altSrc;
    }

    public String getNavSrc() {
        return this.navSrc;
    }

    public void setImageRoot(String imageRoot) {
        this.imageRoot = imageRoot;
    }

    public String getLineBackgroundSrc(boolean shouldShowLineBackground) {
        String img = shouldShowLineBackground ? LINE_TRUNK_GIF : SPACER_GIF;
        return this.imageRoot + img;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }
}

