/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.seasar.util.exception.IORuntimeException;
import org.seasar.util.io.CopyUtil;
import org.seasar.util.misc.AssertionUtil;

public abstract class ReaderUtil {
    private static final int BUF_SIZE = 4096;

    public static InputStreamReader create(InputStream is, String encoding) {
        AssertionUtil.assertArgumentNotNull("is", is);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        try {
            return new InputStreamReader(is, encoding);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Reader create(File file) {
        AssertionUtil.assertArgumentNotNull("file", file);
        try {
            return new FileReader(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Reader create(File file, String encoding) {
        AssertionUtil.assertArgumentNotNull("file", file);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        try {
            return new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String readLine(BufferedReader reader) {
        AssertionUtil.assertArgumentNotNull("reader", reader);
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String readText(Reader reader) {
        AssertionUtil.assertArgumentNotNull("reader", reader);
        StringBuilder buf = new StringBuilder(4096);
        CopyUtil.copy(reader, buf);
        return new String(buf);
    }
}

