/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.exception;

import org.seasar.util.collection.ArrayUtil;
import org.seasar.util.exception.SRuntimeException;
import org.seasar.util.lang.MethodUtil;

public class MethodNotFoundRuntimeException
extends SRuntimeException {
    private static final long serialVersionUID = -3508955801981550317L;
    private final Class<?> targetClass;
    private final String methodName;
    private final Class<?>[] methodArgClasses;

    public MethodNotFoundRuntimeException(Class<?> targetClass, String methodName, Object[] methodArgs) {
        this(targetClass, methodName, MethodNotFoundRuntimeException.toClassArray(methodArgs));
    }

    public MethodNotFoundRuntimeException(Class<?> targetClass, String methodName, Class<?>[] methodArgClasses) {
        super("EUTL0049", ArrayUtil.asArray(targetClass.getName(), MethodUtil.getSignature(methodName, methodArgClasses)));
        this.targetClass = targetClass;
        this.methodName = methodName;
        this.methodArgClasses = methodArgClasses;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?>[] getMethodArgClasses() {
        return this.methodArgClasses;
    }

    private static Class<?>[] toClassArray(Object ... methodArgs) {
        if (methodArgs == null) {
            return null;
        }
        Class[] result = new Class[methodArgs.length];
        for (int i = 0; i < methodArgs.length; ++i) {
            if (methodArgs[i] == null) continue;
            result[i] = methodArgs[i].getClass();
        }
        return result;
    }
}

