/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.convert;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.util.lang.StringUtil;

public abstract class BigDecimalConversionUtil {
    public static BigDecimal toBigDecimal(Object o) {
        return BigDecimalConversionUtil.toBigDecimal(o, null);
    }

    public static BigDecimal toBigDecimal(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new BigDecimal(new SimpleDateFormat(pattern).format(o));
            }
            return new BigDecimal(Long.toString(((Date)o).getTime()));
        }
        if (o instanceof String) {
            String s = (String)o;
            if (StringUtil.isEmpty(s)) {
                return null;
            }
            return BigDecimalConversionUtil.normalize(new BigDecimal(s));
        }
        return BigDecimalConversionUtil.normalize(new BigDecimal(o.toString()));
    }

    public static String toString(BigDecimal dec) {
        return dec.toPlainString();
    }

    private static BigDecimal normalize(BigDecimal dec) {
        return new BigDecimal(dec.toPlainString());
    }
}

