/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.convert;

import java.sql.Time;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.seasar.util.collection.MultiIterator;
import org.seasar.util.exception.ParseRuntimeException;
import org.seasar.util.exception.SNoSuchElementException;
import org.seasar.util.exception.SUnsupportedOperationException;
import org.seasar.util.lang.StringUtil;
import org.seasar.util.misc.AssertionUtil;

public abstract class TimeConversionUtil {
    protected static final int[] STYLES = new int[]{3, 2, 1, 0};

    public static String getShortPattern() {
        return TimeConversionUtil.getShortPattern(Locale.getDefault());
    }

    public static String getShortPattern(Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return ((SimpleDateFormat)DateFormat.getTimeInstance(3, locale)).toPattern();
    }

    public static String getMediumPattern() {
        return TimeConversionUtil.getMediumPattern(Locale.getDefault());
    }

    public static String getMediumPattern(Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return ((SimpleDateFormat)DateFormat.getTimeInstance(2, locale)).toPattern();
    }

    public static String getLongPattern() {
        return TimeConversionUtil.getLongPattern(Locale.getDefault());
    }

    public static String getLongPattern(Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return ((SimpleDateFormat)DateFormat.getTimeInstance(1, locale)).toPattern();
    }

    public static String getFullPattern() {
        return TimeConversionUtil.getFullPattern(Locale.getDefault());
    }

    public static String getFullPattern(Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return ((SimpleDateFormat)DateFormat.getTimeInstance(0, locale)).toPattern();
    }

    public static Date toDate(Object src) {
        return TimeConversionUtil.toDate(src, null, Locale.getDefault());
    }

    public static Date toDate(Object src, String pattern) {
        return TimeConversionUtil.toDate(src, pattern, Locale.getDefault());
    }

    public static Date toDate(Object src, Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return TimeConversionUtil.toDate(src, null, locale);
    }

    protected static Date toDate(Object src, String pattern, Locale locale) {
        SimpleDateFormat format;
        Date date;
        if (src == null) {
            return null;
        }
        if (src.getClass() == Date.class) {
            return (Date)src;
        }
        if (src instanceof Date) {
            return new Date(((Date)src).getTime());
        }
        if (src instanceof Calendar) {
            return new Date(((Calendar)src).getTimeInMillis());
        }
        String str = src.toString();
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        if (StringUtil.isNotEmpty(pattern) && (date = TimeConversionUtil.toDate(str, format = new SimpleDateFormat(pattern, locale))) != null) {
            return date;
        }
        Date date2 = TimeConversionUtil.toDate(str, locale);
        if (date2 != null) {
            return date2;
        }
        Time time = TimeConversionUtil.toSqlTimeJdbcEscape(str);
        if (time != null) {
            return new Date(time.getTime());
        }
        throw new ParseRuntimeException(str);
    }

    public static Calendar toCalendar(Object src) {
        return TimeConversionUtil.toCalendar(src, null, Locale.getDefault());
    }

    public static Calendar toCalendar(Object src, String pattern) {
        return TimeConversionUtil.toCalendar(src, pattern, Locale.getDefault());
    }

    public static Calendar toCalendar(Object src, Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return TimeConversionUtil.toCalendar(src, null, locale);
    }

    protected static Calendar toCalendar(Object src, String pattern, Locale locale) {
        SimpleDateFormat format;
        Date date;
        if (src == null) {
            return null;
        }
        if (src instanceof Calendar) {
            return (Calendar)src;
        }
        if (src instanceof Date) {
            return TimeConversionUtil.toCalendar((Date)src, locale);
        }
        String str = src.toString();
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        if (StringUtil.isNotEmpty(pattern) && (date = TimeConversionUtil.toDate(str, format = new SimpleDateFormat(pattern, locale))) != null) {
            return TimeConversionUtil.toCalendar(date, locale);
        }
        Date date2 = TimeConversionUtil.toDate(str, locale);
        if (date2 != null) {
            return TimeConversionUtil.toCalendar(date2, locale);
        }
        Time time = TimeConversionUtil.toSqlTimeJdbcEscape(str);
        if (time != null) {
            return TimeConversionUtil.toCalendar(time, locale);
        }
        throw new ParseRuntimeException(str);
    }

    public static Time toSqlTime(Object src) {
        return TimeConversionUtil.toSqlTime(src, null, Locale.getDefault());
    }

    public static Time toSqlTime(Object src, String pattern) {
        return TimeConversionUtil.toSqlTime(src, pattern, Locale.getDefault());
    }

    public static Time toSqlTime(Object src, Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return TimeConversionUtil.toSqlTime(src, null, locale);
    }

    protected static Time toSqlTime(Object src, String pattern, Locale locale) {
        SimpleDateFormat format;
        Date date;
        if (src == null) {
            return null;
        }
        if (src.getClass() == Time.class) {
            return (Time)src;
        }
        if (src instanceof Date) {
            return new Time(((Date)src).getTime());
        }
        if (src instanceof Calendar) {
            return new Time(((Calendar)src).getTimeInMillis());
        }
        String str = src.toString();
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        if (StringUtil.isNotEmpty(pattern) && (date = TimeConversionUtil.toDate(str, format = new SimpleDateFormat(pattern, locale))) != null) {
            return new Time(date.getTime());
        }
        Date date2 = TimeConversionUtil.toDate(str, locale);
        if (date2 != null) {
            return new Time(date2.getTime());
        }
        Time time = TimeConversionUtil.toSqlTimeJdbcEscape(str);
        if (time != null) {
            return time;
        }
        throw new ParseRuntimeException(str);
    }

    protected static Date toDate(String str, Locale locale) {
        for (DateFormat format : MultiIterator.iterable(new DateFormatIterator(locale), new PlainDateFormatIterator(str, locale))) {
            Date date;
            if (format == null || (date = TimeConversionUtil.toDate(str, format)) == null) continue;
            return date;
        }
        return null;
    }

    protected static Date toDate(String str, DateFormat format) {
        ParsePosition pos = new ParsePosition(0);
        Date date = format.parse(str, pos);
        if (date == null) {
            return null;
        }
        int index = pos.getIndex();
        if (index == 0) {
            return null;
        }
        if (index < str.length()) {
            return null;
        }
        return date;
    }

    protected static Calendar toCalendar(Date date, Locale locale) {
        Calendar calendar = locale == null ? Calendar.getInstance() : Calendar.getInstance(locale);
        calendar.setTime(date);
        return calendar;
    }

    protected static Time toSqlTimeJdbcEscape(String str) {
        try {
            return Time.valueOf(str);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    protected static String toPlainPattern(String pattern) {
        int pos;
        StringBuilder buf = new StringBuilder(pattern.length());
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (!Character.isLetterOrDigit(ch) && !Character.isWhitespace(ch)) continue;
            buf.append(ch);
        }
        if (buf.indexOf("HH") == -1 && (pos = buf.indexOf("H")) != -1) {
            buf.replace(pos, pos + 1, "HH");
        }
        if (buf.indexOf("mm") == -1 && (pos = buf.indexOf("m")) != -1) {
            buf.replace(pos, pos + 1, "mm");
        }
        if (buf.indexOf("ss") == -1 && (pos = buf.indexOf("s")) != -1) {
            buf.replace(pos, pos + 1, "ss");
        }
        return new String(buf);
    }

    protected static class PlainDateFormatIterator
    implements Iterator<DateFormat> {
        protected final String src;
        protected final Locale locale;
        protected int index;

        public PlainDateFormatIterator(String src, Locale locale) {
            this.src = src;
            this.locale = locale;
        }

        @Override
        public boolean hasNext() {
            return this.index < STYLES.length;
        }

        @Override
        public DateFormat next() {
            SimpleDateFormat simpleFormat;
            String pattern;
            int style;
            DateFormat format;
            if (!this.hasNext()) {
                throw new SNoSuchElementException();
            }
            if ((format = DateFormat.getTimeInstance(style = STYLES[this.index++], this.locale)) instanceof SimpleDateFormat && (pattern = TimeConversionUtil.toPlainPattern((simpleFormat = (SimpleDateFormat)format).toPattern())).length() == this.src.length()) {
                return new SimpleDateFormat(pattern);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new SUnsupportedOperationException("remove");
        }
    }

    protected static class DateFormatIterator
    implements Iterator<DateFormat> {
        protected final Locale locale;
        protected int index;

        public DateFormatIterator(Locale locale) {
            this.locale = locale;
        }

        @Override
        public boolean hasNext() {
            return this.index < STYLES.length;
        }

        @Override
        public DateFormat next() {
            if (!this.hasNext()) {
                throw new SNoSuchElementException();
            }
            int style = STYLES[this.index++];
            return DateFormat.getTimeInstance(style, this.locale);
        }

        @Override
        public void remove() {
            throw new SUnsupportedOperationException("remove");
        }
    }
}

