/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.lang;

import java.util.Iterator;
import org.seasar.util.exception.SNoSuchElementException;
import org.seasar.util.exception.SUnsupportedOperationException;
import org.seasar.util.misc.AssertionUtil;

public class ClassLoaderIterator
implements Iterator<ClassLoader> {
    protected ClassLoader classLoader;

    public static Iterable<ClassLoader> iterable(final ClassLoader classLoader) {
        return new Iterable<ClassLoader>(){

            @Override
            public Iterator<ClassLoader> iterator() {
                return new ClassLoaderIterator(classLoader);
            }
        };
    }

    public ClassLoaderIterator(ClassLoader classLoader) {
        AssertionUtil.assertArgumentNotNull("classLoader", classLoader);
        this.classLoader = classLoader;
    }

    @Override
    public boolean hasNext() {
        return this.classLoader != null;
    }

    @Override
    public ClassLoader next() {
        if (!this.hasNext()) {
            throw new SNoSuchElementException();
        }
        ClassLoader result = this.classLoader;
        this.classLoader = this.classLoader.getParent();
        return result;
    }

    @Override
    public void remove() {
        throw new SUnsupportedOperationException("remove");
    }
}

