/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class IOUtils {
    private static final int BUFFER_BLOCK_SIZE = 4096;

    public static void closeSilently(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Writer writer) {
        if (writer != null) {
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytesAndClose(InputStream in, int length) throws IOException {
        try {
            if (length <= 0) {
                length = Integer.MAX_VALUE;
            }
            int block = Math.min(4096, length);
            ByteArrayOutputStream out = new ByteArrayOutputStream(block);
            byte[] buff = new byte[block];
            while (length > 0) {
                int len = Math.min(block, length);
                if ((len = in.read(buff, 0, len)) < 0) break;
                out.write(buff, 0, len);
                length -= len;
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static String readStringAndClose(Reader in, int length) throws IOException {
        if (length <= 0) {
            length = Integer.MAX_VALUE;
        }
        int block = Math.min(4096, length);
        StringWriter out = new StringWriter(length == Integer.MAX_VALUE ? block : length);
        char[] buff = new char[block];
        while (length > 0) {
            int len = Math.min(block, length);
            if ((len = in.read(buff, 0, len)) < 0) break;
            out.write(buff, 0, len);
            length -= len;
        }
        in.close();
        return out.toString();
    }

    public static int readFully(InputStream in, byte[] buffer, int max) throws IOException {
        int l;
        int off = 0;
        int len = Math.min(max, buffer.length);
        while ((l = len - off) > 0 && (l = in.read(buffer, off, l)) != -1) {
            off += l;
        }
        return off;
    }

    public static int readFully(Reader in, char[] buffer, int max) throws IOException {
        int l;
        int off = 0;
        int len = Math.min(max, buffer.length);
        while ((l = len - off) > 0 && (l = in.read(buffer, off, l)) != -1) {
            off += l;
        }
        return off;
    }
}

