/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.util.FileUtils;

public abstract class FileBase {
    protected boolean allFiles() {
        return false;
    }

    public static ArrayList getDatabaseFiles(String dir, String db, boolean all) throws SQLException {
        ArrayList<String> files = new ArrayList<String>();
        if (dir == null || dir.equals("")) {
            dir = ".";
        }
        String start = db == null ? null : FileUtils.normalize(dir + "/" + db);
        String[] list = FileUtils.listFiles(dir);
        for (int i = 0; list != null && i < list.length; ++i) {
            String f = list[i];
            boolean ok = false;
            if (f.endsWith(".data.db")) {
                ok = true;
            } else if (f.endsWith(".index.db")) {
                ok = true;
            } else if (f.endsWith(".log.db")) {
                ok = true;
            } else if (f.endsWith(".hash.db")) {
                ok = true;
            } else if (f.endsWith(".lobs.db")) {
                files.addAll(FileBase.getDatabaseFiles(f, null, all));
                ok = true;
            } else if (f.endsWith(".lob.db")) {
                ok = true;
            } else if (f.endsWith(".sum.db")) {
                ok = true;
            } else if (all) {
                if (f.endsWith(".lock.db")) {
                    ok = true;
                } else if (f.endsWith(".temp.db")) {
                    ok = true;
                } else if (f.endsWith(".trace.db")) {
                    ok = true;
                }
            }
            if (!ok || db != null && !FileUtils.fileStartsWith(f, start + ".") && !FileUtils.isInMemory(dir)) continue;
            String fileName = f;
            files.add(fileName);
        }
        return files;
    }

    public void processFiles(String dir, String db, boolean log) throws SQLException {
        ArrayList files = FileBase.getDatabaseFiles(dir, db, this.allFiles());
        for (int i = 0; i < files.size(); ++i) {
            String fileName = (String)files.get(i);
            this.process(fileName);
            if (!log) continue;
            System.out.println("processed: " + fileName);
        }
        if (files.size() == 0 && log) {
            System.out.println("No database files found");
        }
    }

    protected abstract void process(String var1) throws SQLException;
}

