/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.LinkedIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.DataType;

public class TableLink
extends Table {
    private String driver;
    private String url;
    private String user;
    private String password;
    private String originalTable;
    private Connection conn;
    private HashMap prepared = new HashMap();
    private ObjectArray indexes = new ObjectArray();

    public TableLink(Schema schema, int id, String name, String driver, String url, String user, String password, String originalTable) throws SQLException {
        super(schema, id, name, false);
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
        this.originalTable = originalTable;
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            throw Message.getSQLException(90086, new String[]{driver}, e);
        }
        this.conn = DriverManager.getConnection(url, user, password);
        DatabaseMetaData meta = this.conn.getMetaData();
        boolean storesLowerCase = meta.storesLowerCaseIdentifiers();
        ResultSet rs = meta.getColumns(null, null, originalTable, null);
        int i = 0;
        ObjectArray columnList = new ObjectArray();
        HashMap<String, Column> columnMap = new HashMap<String, Column>();
        while (rs.next()) {
            String n = rs.getString("COLUMN_NAME");
            if (storesLowerCase && n.equals(n.toLowerCase())) {
                n = n.toUpperCase();
            }
            int sqlType = rs.getInt("DATA_TYPE");
            long precision = rs.getInt("COLUMN_SIZE");
            int scale = rs.getInt("DECIMAL_DIGITS");
            int type = DataType.convertSQLTypeToValueType(sqlType);
            precision = Math.max(precision, DataType.getDataType((int)type).defaultPrecision);
            Column col = new Column(n, type, precision, scale);
            col.setTable(this, i++);
            columnList.add(col);
            columnMap.put(n, col);
        }
        if (columnList.size() == 0) {
            try {
                rs = this.conn.createStatement().executeQuery("SELECT * FROM " + originalTable + " T WHERE 1=0");
                ResultSetMetaData rsm = rs.getMetaData();
                i = 0;
                while (i < rsm.getColumnCount()) {
                    String n = rsm.getColumnName(i + 1);
                    if (storesLowerCase && n.equals(n.toLowerCase())) {
                        n = n.toUpperCase();
                    }
                    int sqlType = rsm.getColumnType(i + 1);
                    long precision = rsm.getPrecision(i + 1);
                    int scale = rsm.getScale(i + 1);
                    int type = DataType.convertSQLTypeToValueType(sqlType);
                    precision = Math.max(precision, DataType.getDataType((int)type).defaultPrecision);
                    Column col = new Column(n, type, precision, scale);
                    col.setTable(this, i++);
                    columnList.add(col);
                    columnMap.put(n, col);
                }
            }
            catch (SQLException e) {
                throw Message.getSQLException(42102, new String[]{originalTable}, e);
            }
        }
        Object[] cols = new Column[columnList.size()];
        columnList.toArray(cols);
        this.setColumns((Column[])cols);
        LinkedIndex index = new LinkedIndex(this, id, (Column[])cols, IndexType.createNonUnique(false));
        this.indexes.add(index);
        rs = meta.getPrimaryKeys(null, null, originalTable);
        String pkName = "";
        if (rs.next()) {
            ObjectArray list = new ObjectArray();
            do {
                int idx = rs.getInt("KEY_SEQ");
                if (pkName == null) {
                    pkName = rs.getString("PK_NAME");
                }
                while (list.size() < idx) {
                    list.add(null);
                }
                String col = rs.getString("COLUMN_NAME");
                Column column = (Column)columnMap.get(col);
                list.set(idx - 1, column);
            } while (rs.next());
            this.addIndex(list, IndexType.createPrimaryKey(false, false));
        }
        rs = meta.getIndexInfo(null, null, originalTable, false, false);
        String indexName = null;
        ObjectArray list = new ObjectArray();
        IndexType indexType = null;
        while (rs.next()) {
            String newIndex = rs.getString("INDEX_NAME");
            if (pkName.equals(newIndex)) continue;
            if (indexName != null && !indexName.equals(newIndex)) {
                this.addIndex(list, indexType);
                indexName = null;
            }
            if (indexName == null) {
                indexName = newIndex;
                list.clear();
            }
            boolean unique = !rs.getBoolean("NON_UNIQUE");
            indexType = unique ? IndexType.createUnique(false, false) : IndexType.createNonUnique(false);
            String col = rs.getString("COLUMN_NAME");
            Column column = (Column)columnMap.get(col);
            list.add(column);
        }
        if (indexName != null) {
            this.addIndex(list, indexType);
        }
    }

    private void addIndex(ObjectArray list, IndexType indexType) {
        Object[] cols = new Column[list.size()];
        list.toArray(cols);
        LinkedIndex index = new LinkedIndex(this, 0, (Column[])cols, indexType);
        this.indexes.add(index);
    }

    public String getCreateSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE LINKED TABLE ");
        buff.append(this.getSQL());
        buff.append("(");
        buff.append(StringUtils.quoteStringSQL(this.driver));
        buff.append(", ");
        buff.append(StringUtils.quoteStringSQL(this.url));
        buff.append(", ");
        buff.append(StringUtils.quoteStringSQL(this.user));
        buff.append(", ");
        buff.append(StringUtils.quoteStringSQL(this.password));
        buff.append(", ");
        buff.append(StringUtils.quoteStringSQL(this.originalTable));
        buff.append(")");
        return buff.toString();
    }

    public Index addIndex(Session session, String indexName, int indexId, Column[] cols, IndexType indexType, int headPos) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void lock(Session session, boolean exclusive) throws SQLException {
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public Index getScanIndex(Session session) {
        return (Index)this.indexes.get(0);
    }

    public void removeRow(Session session, Row row) throws SQLException {
        this.getScanIndex(session).remove(session, row);
    }

    public void addRow(Session session, Row row) throws SQLException {
        this.getScanIndex(session).add(session, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Session session) throws SQLException {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            finally {
                this.conn = null;
            }
        }
    }

    public int getRowCount() throws SQLException {
        PreparedStatement prep = this.getPreparedStatement("SELECT COUNT(*) FROM " + this.originalTable);
        ResultSet rs = prep.executeQuery();
        rs.next();
        int count = rs.getInt(1);
        rs.close();
        return count;
    }

    public String getOriginalTable() {
        return this.originalTable;
    }

    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        PreparedStatement prep = (PreparedStatement)this.prepared.get(sql);
        if (prep == null) {
            prep = this.conn.prepareStatement(sql);
            this.prepared.put(sql, prep);
        }
        return prep;
    }

    public void unlock(Session s) {
    }

    public void checkRename() throws SQLException {
    }

    public void checkSupportAlter() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean canGetRowCount() {
        return true;
    }

    public boolean canDrop() {
        return true;
    }

    public String getTableType() {
        return "TABLE LINK";
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        super.removeChildrenAndResources(session);
        this.close(session);
        this.driver = null;
        this.originalTable = null;
        this.password = null;
        this.user = null;
        this.url = null;
        this.conn = null;
        this.prepared = null;
        this.invalidate();
    }

    public ObjectArray getIndexes() {
        return this.indexes;
    }

    public long getDataModificationId() {
        return this.database.getNextModificationDataId();
    }

    public Index getUniqueIndex() {
        for (int i = 0; i < this.indexes.size(); ++i) {
            Index idx = (Index)this.indexes.get(i);
            if (!idx.getIndexType().isUnique()) continue;
            return idx;
        }
        return null;
    }
}

