/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.sql.SQLException;
import org.h2.command.CommandInterface;
import org.h2.command.Parser;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.util.ObjectArray;

public abstract class Command
implements CommandInterface {
    protected Session session;
    protected long startTime;
    protected Trace trace;
    private volatile boolean cancel;

    public abstract boolean isTransactional();

    public abstract boolean isQuery();

    public abstract ObjectArray getParameters();

    public Command(Parser parser) {
        this.session = parser.getSession();
        this.trace = this.session.getDatabase().getTrace("command");
    }

    public int update() throws SQLException {
        throw Message.getSQLException(90001);
    }

    public LocalResult query(int maxrows) throws SQLException {
        throw Message.getSQLException(90002);
    }

    public ResultInterface executeQuery(int maxrows, boolean scrollable) throws SQLException {
        return this.executeQueryLocal(maxrows);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LocalResult executeQueryLocal(int maxrows) throws SQLException {
        Object sync;
        this.startTime = System.currentTimeMillis();
        Database database = this.session.getDatabase();
        Object object = sync = Constants.MULTI_THREADED_KERNEL ? this.session : database;
        synchronized (object) {
            try {
                LocalResult result;
                database.checkPowerOff();
                this.session.setCurrentCommand(this);
                LocalResult localResult = result = this.query(maxrows);
                return localResult;
            }
            catch (Throwable e) {
                SQLException s = Message.convert(e);
                database.exceptionThrown(s);
                throw s;
            }
            finally {
                this.stop();
            }
        }
    }

    protected void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void checkCancelled() throws SQLException {
        if (this.cancel) {
            throw Message.getSQLException(90051);
        }
        this.session.throttle();
    }

    private void stop() throws SQLException {
        long time;
        this.session.setCurrentCommand(null);
        if (!this.isTransactional()) {
            this.session.commit();
        } else if (this.session.getAutoCommit()) {
            this.session.commit();
        }
        if (this.trace.info() && (time = System.currentTimeMillis() - this.startTime) > 100L) {
            this.trace.info("long query: " + time);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate() throws SQLException {
        Object sync;
        this.startTime = System.currentTimeMillis();
        Database database = this.session.getDatabase();
        Object object = sync = Constants.MULTI_THREADED_KERNEL ? this.session : database;
        synchronized (object) {
            int rollback = this.session.getLogId();
            this.session.setCurrentCommand(this);
            try {
                int result;
                database.checkPowerOff();
                int n = result = this.update();
                return n;
            }
            catch (SQLException e) {
                database.exceptionThrown(e);
                database.checkPowerOff();
                this.session.rollbackTo(rollback);
                throw e;
            }
            finally {
                this.stop();
            }
        }
    }

    public void close() {
    }

    public void cancel() {
        this.cancel = true;
    }
}

