${header}<#include "macro/FindProperty.ftl"/>
package ${package}.${defaultDir?lower_case};

import org.seasar.codegen.lib.Condition;
import org.seasar.codegen.lib.ConditionResult;
import org.seasar.codegen.lib.impl.ColumnImpl;
import org.seasar.codegen.lib.impl.ConditionResultImpl;
import org.seasar.dao.pager.DefaultPagerCondition;

/**
 * ${table.tableName}テーブルに対する検索条件です。
 * @author S2Dao-CodeGen
 */
public class ${table.tableNameForDto?cap_first}${defaultDir} extends DefaultPagerCondition implements Condition {

	private static final long serialVersionUID = 1L;

	private String alias;

	protected ConditionResult conditionResult;

	/**
	 * コンストラクタです。
	 * 
	 * @param alias 表の別名
	 * @param conditionResult 検索条件
	 */
	${table.tableNameForDto?cap_first}${defaultDir}(ConditionResult conditionResult,String alias) {
		this.alias = alias;
		this.conditionResult = conditionResult;
	}

	/**
	 * コンストラクタです。表の別名はテーブル名になります。
	 */
	public ${table.tableNameForDto?cap_first}${defaultDir}() {
		this.alias = "${table.tableName}";
		this.conditionResult = new ConditionResultImpl();
	}

	public ConditionResult getConditionResult() {
		return conditionResult;
	}

	<@proerty table=table tableName="" suffix=""/>

	public void addQuery(String query, Object... args) {
		conditionResult.addQuery(query, args);
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(conditionResult.toString());
		sb.append("/offset=");
		sb.append(getOffset());
		sb.append("/limit=");
		sb.append(getLimit());
		return sb.toString();
	}

}
