/*
 * Copyright 2004-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.unit.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.ResourceUtil;

public class CSVUtil {

    public static List<String[]> readCSV(String path) {
        BufferedReader reader = null;
        try {
            List<String[]> ret = new ArrayList<String[]>();
            reader = new BufferedReader(new InputStreamReader(
                    ResourceUtil.getResourceAsStream(path), "Windows-31J"));
            String line = reader.readLine();
            while (line != null) {
                ret.add(line.split(","));
                line = reader.readLine();
            }
            return ret;
        } catch (IOException e) {
            throw new IORuntimeException(e);
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException ignore) {
                }
            }
        }
    }

}
