/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.dbms;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.RelationPropertyType;
import org.seasar.dao.dbms.Standard;
import org.seasar.extension.jdbc.util.DatabaseMetaDataUtil;
import org.seasar.framework.exception.SQLRuntimeException;

public class Oracle
extends Standard {
    public String getSuffix() {
        return "_oracle";
    }

    protected String createAutoSelectFromClause(BeanMetaData beanMetaData) {
        StringBuffer buf = new StringBuffer(100);
        buf.append("FROM ");
        String myTableName = beanMetaData.getTableName();
        buf.append(myTableName);
        StringBuffer whereBuf = new StringBuffer(100);
        for (int i = 0; i < beanMetaData.getRelationPropertyTypeSize(); ++i) {
            RelationPropertyType rpt = beanMetaData.getRelationPropertyType(i);
            BeanMetaData bmd = rpt.getBeanMetaData();
            buf.append(", ");
            buf.append(bmd.getTableName());
            buf.append(" ");
            String yourAliasName = rpt.getPropertyName();
            buf.append(yourAliasName);
            for (int j = 0; j < rpt.getKeySize(); ++j) {
                whereBuf.append(myTableName);
                whereBuf.append(".");
                whereBuf.append(rpt.getMyKey(j));
                whereBuf.append(" = ");
                whereBuf.append(yourAliasName);
                whereBuf.append(".");
                whereBuf.append(rpt.getYourKey(j));
                whereBuf.append("(+)");
                whereBuf.append(" AND ");
            }
        }
        if (whereBuf.length() > 0) {
            whereBuf.setLength(whereBuf.length() - 5);
            buf.append(" WHERE ");
            buf.append(whereBuf);
        }
        return buf.toString();
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    public ResultSet getProcedures(DatabaseMetaData databaseMetaData, String procedureName) {
        String[] names = DatabaseMetaDataUtil.convertIdentifier((DatabaseMetaData)databaseMetaData, (String)procedureName).split("\\.");
        int namesLength = names.length;
        ResultSet rs = null;
        try {
            if (namesLength == 1) {
                rs = databaseMetaData.getProcedures(null, "", names[0]);
                if (!rs.isBeforeFirst()) {
                    rs.close();
                    rs = databaseMetaData.getProcedures(null, null, names[0]);
                }
            } else if (namesLength == 2) {
                rs = databaseMetaData.getProcedures(null, names[0], names[1]);
                if (!rs.isBeforeFirst()) {
                    rs.close();
                    rs = databaseMetaData.getProcedures(names[0], "", names[1]);
                    if (!rs.isBeforeFirst()) {
                        rs.close();
                        rs = databaseMetaData.getProcedures(names[0], null, names[1]);
                    }
                }
            } else if (namesLength == 3) {
                rs = databaseMetaData.getProcedures(names[1], names[0], names[2]);
            } else {
                throw new IllegalArgumentException();
            }
            return rs;
        }
        catch (SQLException e) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            throw new SQLRuntimeException(e);
        }
    }
}

