/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dialect.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.Validate;
import org.jiemamy.dialect.DefaultDbObjectImportVisitor;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.dialect.mysql.MySqlDialect;
import org.jiemamy.dialect.mysql.parameter.MySqlParameterKeys;
import org.jiemamy.dialect.mysql.parameter.StandardEngine;
import org.jiemamy.dialect.mysql.parameter.StorageEngineType;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.SimpleDbObject;
import org.jiemamy.model.view.SimpleJmView;
import org.jiemamy.utils.sql.metadata.TableMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlDbObjectImportVisitor
extends DefaultDbObjectImportVisitor {
    private static Logger logger = LoggerFactory.getLogger(MySqlDbObjectImportVisitor.class);

    public MySqlDbObjectImportVisitor(MySqlDialect dialect) {
        super((Dialect)dialect);
    }

    protected DbObject createDbObject(TableMeta tableMeta) throws SQLException {
        SimpleDbObject dbObject;
        block5: {
            dbObject = (SimpleDbObject)super.createDbObject(tableMeta);
            try {
                StorageEngineType engineType;
                Connection connection = this.getMeta().getMetaData().getConnection();
                final String engineTypeString = this.getEngineType(connection, dbObject.getName());
                if (engineTypeString == null) break block5;
                try {
                    engineType = StandardEngine.valueOf(engineTypeString);
                }
                catch (IllegalArgumentException e) {
                    engineType = new StorageEngineType(){

                        public String toString() {
                            return engineTypeString;
                        }
                    };
                }
                dbObject.putParam(MySqlParameterKeys.STORAGE_ENGINE, (Object)engineType);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("exception is thrown", (Throwable)e);
            }
        }
        return dbObject;
    }

    protected SimpleJmView createView(String viewName) throws SQLException {
        Validate.notNull((Object)viewName);
        SimpleJmView view = new SimpleJmView();
        view.setName(viewName);
        try {
            Connection connection = this.getMeta().getMetaData().getConnection();
            String definition = this.getViewDefinition(connection, viewName);
            view.setDefinition(definition);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("exception is thrown", (Throwable)e);
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getEngineType(Connection conn, String tableName) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("SHOW TABLE STATUS");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString(1).equals(tableName)) continue;
                String string = rs.getString(2);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getViewDefinition(Connection conn, String viewName) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("select * from information_schema.VIEWS where table_name = ?;");
            ps.setString(1, viewName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString("VIEW_DEFINITION");
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }
}

