/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.transaction;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.jiemamy.transaction.DispatchStrategy;
import org.jiemamy.transaction.EventBroker;
import org.jiemamy.transaction.StoredEvent;
import org.jiemamy.transaction.StoredEventListener;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventBrokerImpl
implements EventBroker {
    private static Logger logger = LoggerFactory.getLogger(EventBrokerImpl.class);
    private List<StoredEventListener> listeners = Lists.newArrayList();
    private DispatchStrategy strategy = new DefaultDispatchStrategy();
    private Map<StoredEventListener, DispatchStrategy> strategies = Maps.newHashMap();

    @Override
    public void addListener(StoredEventListener listener) {
        Validate.notNull((Object)listener);
        this.listeners.add(listener);
        logger.info((Marker)LogMarker.LIFECYCLE, "CommandListener is registered: " + listener.toString());
    }

    @Override
    public void addListener(StoredEventListener listener, DispatchStrategy strategy) {
        Validate.notNull((Object)listener);
        Validate.notNull((Object)strategy);
        this.listeners.add(listener);
        this.strategies.put(listener, strategy);
        logger.info((Marker)LogMarker.LIFECYCLE, "CommandListener and DispatchStrategy is registered: " + listener.toString() + "," + strategy.toString());
    }

    @Override
    public void fireEvent(StoredEvent<?> command) {
        Validate.notNull(command);
        logger.trace((Marker)LogMarker.LIFECYCLE, "EventBroker is kicked enter: " + command.toString());
        ArrayList listenersSnapthot = Lists.newArrayList(this.listeners);
        for (StoredEventListener listener : listenersSnapthot) {
            boolean needToDispatch = false;
            needToDispatch = this.strategies.containsKey(listener) ? this.strategies.get(listener).needToDispatch(listener, command) : this.strategy.needToDispatch(listener, command);
            if (!needToDispatch) continue;
            listener.handleStoredEvent(command);
            logger.debug((Marker)LogMarker.LIFECYCLE, "Listener is kicked: " + listener.toString());
        }
        logger.trace((Marker)LogMarker.LIFECYCLE, "EventBroker is kicked exit: " + command.toString());
    }

    public List<StoredEventListener> getListeners() {
        return Lists.newArrayList(this.listeners);
    }

    @Override
    public void removeListener(StoredEventListener listener) {
        Validate.notNull((Object)listener);
        this.listeners.remove(listener);
        if (this.strategies.containsKey(listener)) {
            this.strategies.remove(listener);
        }
        logger.info((Marker)LogMarker.LIFECYCLE, "CommandListener is unregistered: " + listener.toString());
    }

    @Override
    public void setDefaultStrategy(DispatchStrategy strategy) {
        Validate.notNull((Object)strategy);
        this.strategy = strategy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultDispatchStrategy
    implements DispatchStrategy {
        DefaultDispatchStrategy() {
        }

        @Override
        public boolean needToDispatch(StoredEventListener listener, StoredEvent<?> command) {
            return true;
        }
    }
}

