/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.table;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.dddbase.OnMemoryCompositeEntityResolver;
import org.jiemamy.dddbase.OnMemoryEntityResolver;
import org.jiemamy.dddbase.OnMemoryRepository;
import org.jiemamy.dddbase.OrderedEntity;
import org.jiemamy.dddbase.OrderedOnMemoryRepository;
import org.jiemamy.dddbase.Repository;
import org.jiemamy.dddbase.utils.MutationMonitor;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.SimpleDbObject;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.constraint.JmConstraint;
import org.jiemamy.model.constraint.JmForeignKeyConstraint;
import org.jiemamy.model.constraint.JmKeyConstraint;
import org.jiemamy.model.constraint.JmNotNullConstraint;
import org.jiemamy.model.constraint.JmPrimaryKeyConstraint;
import org.jiemamy.model.parameter.ParameterMap;
import org.jiemamy.model.table.ColumnNotFoundException;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.model.table.TableParameterKey;
import org.jiemamy.model.table.TooManyColumnsFoundException;
import org.jiemamy.transaction.EventBroker;
import org.jiemamy.transaction.EventBrokerImpl;
import org.jiemamy.transaction.StoredEvent;
import org.jiemamy.utils.LogMarker;
import org.jiemamy.utils.UUIDUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJmTable
extends SimpleDbObject
implements JmTable {
    private static Logger logger = LoggerFactory.getLogger(SimpleJmTable.class);
    private OrderedOnMemoryRepository<JmColumn> columns = new OrderedOnMemoryRepository();
    private OnMemoryRepository<JmConstraint> constraints = new OnMemoryRepository();
    private final EventBroker eventBroker = new EventBrokerImpl();

    public SimpleJmTable() {
        this(UUID.randomUUID());
    }

    public SimpleJmTable(UUID id) {
        super(id);
    }

    @Override
    public SimpleJmTable clone() {
        SimpleJmTable clone = (SimpleJmTable)super.clone();
        clone.columns = this.columns.clone();
        clone.constraints = this.constraints.clone();
        return clone;
    }

    public boolean contains(EntityRef<?> reference) {
        Validate.notNull(reference);
        return this.contains(reference.getReferentId());
    }

    public boolean contains(UUID id) {
        return new OnMemoryCompositeEntityResolver(new OnMemoryEntityResolver[]{this.columns, this.constraints}).contains(id);
    }

    public JmColumn deleteColumn(EntityRef<? extends JmColumn> reference) {
        Validate.notNull(reference);
        JmColumn deleted = (JmColumn)this.columns.delete(reference);
        logger.info("column deleted: " + deleted);
        this.eventBroker.fireEvent(new StoredEvent<Object>((Repository<Object>)this.columns, deleted, null));
        return deleted;
    }

    public JmConstraint deleteConstraint(EntityRef<? extends JmConstraint> reference) {
        Validate.notNull(reference);
        JmConstraint deleted = (JmConstraint)this.constraints.delete(reference);
        logger.info("constraint deleted: " + deleted);
        this.eventBroker.fireEvent(new StoredEvent<Object>((Repository<Object>)this.constraints, deleted, null));
        return deleted;
    }

    @Override
    public JmKeyConstraint findReferencedKeyConstraint(JmForeignKeyConstraint foreignKey) {
        Validate.notNull((Object)foreignKey);
        for (JmKeyConstraint jmKeyConstraint : this.getKeyConstraints()) {
            if (jmKeyConstraint.getKeyColumns().size() != foreignKey.getReferenceColumns().size() || !jmKeyConstraint.getKeyColumns().containsAll(foreignKey.getReferenceColumns())) continue;
            return jmKeyConstraint;
        }
        return null;
    }

    @Override
    public Set<DbObject> findSuperDbObjectsNonRecursive(Set<DbObject> dbObjects) {
        Validate.notNull(dbObjects);
        HashSet results = Sets.newHashSet();
        for (JmForeignKeyConstraint jmForeignKeyConstraint : this.getForeignKeyConstraints()) {
            JmKeyConstraint referencedKeyConstraint = jmForeignKeyConstraint.findReferencedKeyConstraint(dbObjects);
            if (referencedKeyConstraint == null) continue;
            Iterable tables = Iterables.filter(dbObjects, JmTable.class);
            JmTable declaringTable = referencedKeyConstraint.findDeclaringTable(tables);
            results.add(declaringTable);
        }
        return results;
    }

    @Override
    public JmColumn getColumn(EntityRef<? extends JmColumn> reference) {
        Validate.notNull(reference);
        return this.resolve((EntityRef<T>)((EntityRef)reference));
    }

    @Override
    public JmColumn getColumn(final String name) {
        assert (this.columns != null);
        Collection c = Collections2.filter((Collection)this.columns.getEntitiesAsList(), (Predicate)new Predicate<JmColumn>(){

            public boolean apply(JmColumn column) {
                return column.getName().equals(name);
            }
        });
        try {
            return (JmColumn)Iterables.getOnlyElement((Iterable)c);
        }
        catch (NoSuchElementException e) {
            throw new ColumnNotFoundException("name=" + name);
        }
        catch (IllegalArgumentException e) {
            throw new TooManyColumnsFoundException(c);
        }
    }

    @Override
    public List<JmColumn> getColumns() {
        assert (this.columns != null);
        return this.columns.getEntitiesAsList();
    }

    @Override
    public <T extends JmColumn> List<T> getColumns(Class<T> clazz) {
        Validate.notNull(clazz);
        ArrayList result = Lists.newArrayList((Iterable)Iterables.filter(this.getColumns(), clazz));
        return MutationMonitor.monitor((List)result);
    }

    @Override
    public Set<? extends JmConstraint> getConstraints() {
        return this.constraints.getEntitiesAsSet();
    }

    public <T extends JmConstraint> Set<T> getConstraints(Class<T> clazz) {
        Validate.notNull(clazz);
        HashSet result = Sets.newHashSet((Iterable)Iterables.filter(this.getConstraints(), clazz));
        return MutationMonitor.monitor((Set)result);
    }

    public EventBroker getEventBroker() {
        return this.eventBroker;
    }

    @Override
    public Collection<? extends JmForeignKeyConstraint> getForeignKeyConstraints() {
        return this.getConstraints(JmForeignKeyConstraint.class);
    }

    @Override
    public Collection<? extends JmKeyConstraint> getKeyConstraints() {
        return this.getConstraints(JmKeyConstraint.class);
    }

    @Override
    public JmNotNullConstraint getNotNullConstraintFor(EntityRef<? extends JmColumn> reference) {
        Validate.notNull(reference);
        for (JmNotNullConstraint nn : this.getConstraints(JmNotNullConstraint.class)) {
            EntityRef<? extends JmColumn> columnRef = nn.getColumn();
            if (columnRef == null) {
                logger.warn("target column of NOT NULL is null: " + UUIDUtil.toShortString((UUID)nn.getId()));
                continue;
            }
            if (!columnRef.equals(reference)) continue;
            return nn;
        }
        return null;
    }

    @Override
    public <T> T getParam(TableParameterKey<T> key) {
        return super.getParam(key);
    }

    @Override
    public JmPrimaryKeyConstraint getPrimaryKey() {
        Iterable pks = Iterables.filter((Iterable)this.constraints.getEntitiesAsSet(), JmPrimaryKeyConstraint.class);
        try {
            return (JmPrimaryKeyConstraint)Iterables.getOnlyElement((Iterable)pks);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public Collection<? extends Entity> getSubEntities() {
        return Lists.newArrayList((Iterable)Iterables.concat(this.getColumns(), this.getConstraints()));
    }

    @Override
    public boolean isNotNullColumn(EntityRef<? extends JmColumn> columnRef) {
        Collection nns = this.getConstraints(JmNotNullConstraint.class);
        for (JmNotNullConstraint nn : nns) {
            EntityRef<? extends JmColumn> nnTargetColumnRef = nn.getColumn();
            if (nnTargetColumnRef == null || !nnTargetColumnRef.equals(columnRef)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPrimaryKeyColumn(EntityRef<? extends JmColumn> reference) {
        JmPrimaryKeyConstraint primaryKey = this.getPrimaryKey();
        if (primaryKey == null) {
            return false;
        }
        return primaryKey.getKeyColumns().contains(reference);
    }

    @Override
    public boolean isSubDbObjectsNonRecursiveOf(DbObject target, JiemamyContext context) {
        Validate.notNull((Object)target);
        Validate.notNull((Object)context);
        Set<JmTable> tables = context.getTables();
        for (JmForeignKeyConstraint jmForeignKeyConstraint : this.getForeignKeyConstraints()) {
            EntityRef<? extends JmColumn> columnRef;
            JmTable referenceTable;
            if (jmForeignKeyConstraint.getReferenceColumns().size() == 0 || !(referenceTable = context.resolve(columnRef = jmForeignKeyConstraint.getReferenceColumns().get(0)).findDeclaringTable(tables)).equals(target)) continue;
            return true;
        }
        return false;
    }

    public <T> void putParam(TableParameterKey<T> key, T value) {
        super.putParam(key, value);
    }

    public void removeParam(TableParameterKey<?> key) {
        super.removeParam(key);
    }

    public <T extends Entity> T resolve(EntityRef<T> reference) {
        return (T)new OnMemoryCompositeEntityResolver(new OnMemoryEntityResolver[]{this.columns, this.constraints}).resolve(reference);
    }

    @Override
    public Entity resolve(UUID id) {
        return new OnMemoryCompositeEntityResolver(new OnMemoryEntityResolver[]{this.columns, this.constraints}).resolve(id);
    }

    public void store(JmColumn column) {
        Validate.notNull((Object)column);
        JmColumn old = (JmColumn)this.columns.store((OrderedEntity)column);
        if (old == null) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "column stored: " + column);
        } else {
            logger.debug((Marker)LogMarker.LIFECYCLE, "column updated: (old)" + old);
            logger.debug((Marker)LogMarker.LIFECYCLE, "                (new)" + column);
        }
        this.eventBroker.fireEvent(new StoredEvent<JmColumn>((Repository<JmColumn>)this.columns, old, column));
    }

    public void store(JmConstraint constraint) {
        Validate.notNull((Object)constraint);
        JmConstraint old = (JmConstraint)this.constraints.store((Entity)constraint);
        this.eventBroker.fireEvent(new StoredEvent<JmConstraint>((Repository<JmConstraint>)this.constraints, old, constraint));
        if (old == null) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "constraint stored: " + constraint);
        } else {
            logger.debug((Marker)LogMarker.LIFECYCLE, "constraint updated: (old)" + old);
            logger.debug((Marker)LogMarker.LIFECYCLE, "                    (new)" + constraint);
        }
    }

    public void swapColumn(int index1, int index2) {
        this.columns.swap(index1, index2);
        this.eventBroker.fireEvent(new StoredEvent<Object>((Repository<Object>)this.columns, null, null));
    }

    public EntityRef<? extends SimpleJmTable> toReference() {
        return new DefaultEntityRef((Entity)this);
    }

    ParameterMap breachEncapsulationOfParams() {
        return this.params;
    }
}

