/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.dataset;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.Validate;
import org.codehaus.staxmate.in.SMEvent;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.EntityNotFoundException;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.model.dataset.JmRecord;
import org.jiemamy.model.dataset.SimpleJmDataSet;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.JiemamyOutputContainer;
import org.jiemamy.serializer.stax.JiemamyOutputElement;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.xml.CoreQName;
import org.jiemamy.xml.JiemamyQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmDataSetStaxHandler
extends StaxHandler<SimpleJmDataSet> {
    private static Logger logger = LoggerFactory.getLogger(SimpleJmDataSetStaxHandler.class);

    public SimpleJmDataSetStaxHandler(StaxDirector director) {
        super(director);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public SimpleJmDataSet handleDeserialization(DeserializationContext dctx) throws SerializationException {
        Validate.notNull((Object)dctx);
        try {
            Validate.isTrue((boolean)(dctx.peek().getCurrEvent() == SMEvent.START_ELEMENT));
            Validate.isTrue((boolean)dctx.peek().isQName(CoreQName.DATASET));
            cursor = dctx.peek();
            idString = cursor.getAttrValue(CoreQName.ID);
            id = dctx.getContext().toUUID(idString);
            dataSet = new SimpleJmDataSet(id);
            childCursor = cursor.childElementCursor();
            dctx.push(childCursor);
            do {
                childCursor.advance();
                if (childCursor.getCurrEvent() != SMEvent.START_ELEMENT) ** GOTO lbl50
                if (childCursor.isQName(CoreQName.NAME)) {
                    dataSet.setName(childCursor.collectDescendantText(false));
                    continue;
                }
                if (childCursor.isQName(CoreQName.TABLE_RECORDS)) {
                    tableRecordsCursor = childCursor.childElementCursor();
                    while (tableRecordsCursor.getNext() != null) {
                        if (!tableRecordsCursor.isQName(CoreQName.TABLE_RECORD)) {
                            SimpleJmDataSetStaxHandler.logger.warn("unexpected: " + tableRecordsCursor.getQName());
                            continue;
                        }
                        strRef = tableRecordsCursor.getAttrValue(CoreQName.REF);
                        if (!SimpleJmDataSetStaxHandler.$assertionsDisabled && strRef == null) {
                            throw new AssertionError();
                        }
                        referenceId = dctx.getContext().toUUID(strRef);
                        tableRef = DefaultEntityRef.of((UUID)referenceId);
                        recordsCursor = tableRecordsCursor.childElementCursor();
                        records = Lists.newArrayList();
                        while (recordsCursor.getNext() != null) {
                            if (!recordsCursor.isQName(CoreQName.RECORDS)) {
                                SimpleJmDataSetStaxHandler.logger.warn("unexpected: " + recordsCursor.getQName());
                                continue;
                            }
                            dctx.push(recordsCursor);
                            record = (JmRecord)this.getDirector().direct(dctx);
                            if (record != null) {
                                records.add(record);
                            } else {
                                SimpleJmDataSetStaxHandler.logger.warn("null recode");
                            }
                            dctx.pop();
                        }
                        dataSet.putRecord((EntityRef<? extends JmTable>)tableRef, records);
                    }
                } else {
                    SimpleJmDataSetStaxHandler.logger.warn("UNKNOWN ELEMENT: {}", (Object)childCursor.getQName().toString());
                    continue;
lbl50:
                    // 1 sources

                    if (childCursor.getCurrEvent() == null) continue;
                    SimpleJmDataSetStaxHandler.logger.warn("UNKNOWN EVENT: {}", (Object)childCursor.getCurrEvent());
                }
            } while (childCursor.getCurrEvent() != null);
            dctx.pop();
            return dataSet;
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void handleSerialization(SimpleJmDataSet model, SerializationContext sctx) throws SerializationException {
        Validate.notNull((Object)model);
        Validate.notNull((Object)sctx);
        JiemamyOutputContainer parent = sctx.peek();
        try {
            JiemamyOutputElement element = parent.addElement(CoreQName.DATASET);
            element.addAttribute((JiemamyQName)CoreQName.ID, model.getId());
            element.addElementAndCharacters((JiemamyQName)CoreQName.NAME, model.getName());
            JiemamyOutputElement tableRecordsElement = element.addElement(CoreQName.TABLE_RECORDS);
            sctx.push(tableRecordsElement);
            JiemamyContext context = sctx.getContext();
            for (Map.Entry<EntityRef<? extends JmTable>, List<JmRecord>> entry : model.getRecords().entrySet()) {
                EntityRef<? extends JmTable> tableRef = entry.getKey();
                JiemamyOutputElement tableRecordElement = tableRecordsElement.addElement(CoreQName.TABLE_RECORD);
                tableRecordElement.addAttribute((JiemamyQName)CoreQName.REF, tableRef.getReferentId());
                if (JiemamyContext.isDebug()) {
                    try {
                        String name = context.resolve(tableRef).getName();
                        tableRecordElement.addComment(" TableName: " + name + " ");
                    }
                    catch (EntityNotFoundException e) {
                        tableRecordElement.addComment(" !!! JmTableBuilder cannot resolved !!! ");
                    }
                }
                sctx.push(tableRecordElement);
                sctx.setCurrentTableRef(tableRef);
                for (JmRecord record : entry.getValue()) {
                    this.getDirector().direct(record, sctx);
                }
                sctx.setCurrentTableRef(null);
                sctx.pop();
            }
            sctx.pop();
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }
}

