/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.validator.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jiemamy.JiemamyContext;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.validator.AbstractProblem;
import org.jiemamy.validator.AbstractValidator;
import org.jiemamy.validator.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableValidator
extends AbstractValidator {
    public Collection<Problem> validate(JiemamyContext context) {
        ArrayList problems = Lists.newArrayList();
        for (JmTable table : context.getTables()) {
            List<JmColumn> columns = table.getColumns();
            if (columns.size() == 0) {
                problems.add(new NoColumnProblem(table));
            }
            if (!StringUtils.isEmpty((String)table.getName())) continue;
            problems.add(new EmptyTableNameProblem(table));
        }
        return problems;
    }

    static class NoColumnProblem
    extends AbstractProblem {
        public NoColumnProblem(JmTable table) {
            super(table, "W0060", new Object[]{table.getName()});
        }
    }

    static class EmptyTableNameProblem
    extends AbstractProblem {
        public EmptyTableNameProblem(JmTable table) {
            super(table, "E0170", new Object[]{table.getId().toString()});
        }
    }
}

