/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.validator.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.validator.AbstractProblem;
import org.jiemamy.validator.AbstractValidator;
import org.jiemamy.validator.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnValidator
extends AbstractValidator {
    public Collection<Problem> validate(JiemamyContext context) {
        ArrayList problems = Lists.newArrayList();
        for (JmTable table : context.getTables()) {
            int index = 0;
            for (JmColumn column : table.getColumns()) {
                if (StringUtils.isEmpty((String)column.getName())) {
                    problems.add(new EmptyColumnNameProblem(table, column, index));
                }
                if (column.getDataType() == null) {
                    problems.add(new EmptyDataTypeProblem(table, column));
                }
                ++index;
            }
        }
        return problems;
    }

    static class EmptyDataTypeProblem
    extends AbstractProblem {
        public EmptyDataTypeProblem(JmTable table, JmColumn column) {
            super((Entity)column, "E0050", new Object[]{table.getName(), column.getName()});
        }
    }

    static class EmptyColumnNameProblem
    extends AbstractProblem {
        public EmptyColumnNameProblem(JmTable table, JmColumn column, int index) {
            super((Entity)column, "E0040", new Object[]{table.getName(), index + 1});
        }
    }
}

