/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.ModelConsistencyException;
import org.jiemamy.validator.Validator;
import org.jiemamy.validator.impl.CyclicForeignReferenceValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DbObjectDependencyCalculator {
    private static final Validator VALIDATOR = new CyclicForeignReferenceValidator();

    public static List<DbObject> getSortedEntityList(JiemamyContext context) {
        Validate.notNull((Object)context);
        if (VALIDATOR.validate(context).size() > 0) {
            throw new ModelConsistencyException();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)context.getDbObjects().size());
        for (DbObject dbObject : context.getDbObjects()) {
            DbObjectDependencyCalculator.addDependsdentsToResult(dbObject, context, result);
            DbObjectDependencyCalculator.addToResult(dbObject, result);
        }
        return result;
    }

    private static void addDependsdentsToResult(DbObject dbObject, JiemamyContext context, List<DbObject> result) {
        Set<DbObject> dependents = context.findSuperDbObjectsNonRecursive(dbObject);
        for (DbObject dependent : dependents) {
            if (dependent.equals(dbObject)) continue;
            DbObjectDependencyCalculator.addDependsdentsToResult(dependent, context, result);
            DbObjectDependencyCalculator.addToResult(dependent, result);
        }
    }

    private static void addToResult(DbObject dbObject, List<DbObject> result) {
        if (!result.contains(dbObject)) {
            result.add(dbObject);
        }
    }

    private DbObjectDependencyCalculator() {
    }
}

