/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.table;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.Validate;
import org.codehaus.staxmate.in.SMEvent;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.constraint.JmConstraint;
import org.jiemamy.model.parameter.ParameterMap;
import org.jiemamy.model.table.SimpleJmTable;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.JiemamyCursor;
import org.jiemamy.serializer.stax.JiemamyOutputContainer;
import org.jiemamy.serializer.stax.JiemamyOutputElement;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.utils.ConstraintComparator;
import org.jiemamy.xml.CoreQName;
import org.jiemamy.xml.JiemamyQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmTableStaxHandler
extends StaxHandler<SimpleJmTable> {
    private static Logger logger = LoggerFactory.getLogger(SimpleJmTableStaxHandler.class);

    public SimpleJmTableStaxHandler(StaxDirector director) {
        super(director);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SimpleJmTable handleDeserialization(DeserializationContext dctx) throws SerializationException {
        Validate.notNull((Object)dctx);
        try {
            Validate.isTrue((dctx.peek().getCurrEvent() == SMEvent.START_ELEMENT ? 1 : 0) != 0);
            Validate.isTrue((boolean)dctx.peek().isQName(CoreQName.TABLE));
            JiemamyCursor cursor = dctx.peek();
            String idString = cursor.getAttrValue(CoreQName.ID);
            UUID id = dctx.getContext().toUUID(idString);
            SimpleJmTable table = new SimpleJmTable(id);
            JiemamyCursor childCursor = cursor.childElementCursor();
            dctx.push(childCursor);
            do {
                ParameterMap params;
                JiemamyCursor parameterCursor;
                block18: {
                    JiemamyCursor constraintsCursor;
                    block22: {
                        JiemamyCursor columnsCursor;
                        block21: {
                            block19: {
                                block20: {
                                    childCursor.advance();
                                    if (childCursor.getCurrEvent() != SMEvent.START_ELEMENT) break block19;
                                    if (childCursor.isQName(CoreQName.NAME)) {
                                        table.setName(childCursor.collectDescendantText(false));
                                        continue;
                                    }
                                    if (childCursor.isQName(CoreQName.LOGICAL_NAME)) {
                                        table.setLogicalName(childCursor.collectDescendantText(false));
                                        continue;
                                    }
                                    if (childCursor.isQName(CoreQName.DESCRIPTION)) {
                                        table.setDescription(childCursor.collectDescendantText(false));
                                        continue;
                                    }
                                    if (!childCursor.isQName(CoreQName.COLUMNS)) break block20;
                                    columnsCursor = childCursor.childElementCursor();
                                    break block21;
                                }
                                if (childCursor.isQName(CoreQName.CONSTRAINTS)) {
                                    constraintsCursor = childCursor.childElementCursor();
                                    break block22;
                                } else if (childCursor.isQName(CoreQName.PARAMETERS)) {
                                    parameterCursor = childCursor.childElementCursor();
                                    params = table.breachEncapsulationOfParams();
                                    break block18;
                                } else {
                                    logger.warn("UNKNOWN ELEMENT: {}", (Object)childCursor.getQName().toString());
                                    continue;
                                }
                            }
                            if (childCursor.getCurrEvent() == null) continue;
                            logger.warn("UNKNOWN EVENT: {}", (Object)childCursor.getCurrEvent());
                            continue;
                        }
                        while (columnsCursor.getNext() != null) {
                            dctx.push(columnsCursor);
                            JmColumn column = (JmColumn)this.getDirector().direct(dctx);
                            if (column != null) {
                                table.store(column);
                            } else {
                                logger.warn("null column");
                            }
                            dctx.pop();
                        }
                        continue;
                    }
                    while (constraintsCursor.getNext() != null) {
                        dctx.push(constraintsCursor);
                        JmConstraint constraint = (JmConstraint)this.getDirector().direct(dctx);
                        if (constraint != null) {
                            table.store(constraint);
                        } else {
                            logger.warn("null constraint");
                        }
                        dctx.pop();
                    }
                    continue;
                }
                while (parameterCursor.getNext() != null) {
                    if (!parameterCursor.isQName(CoreQName.PARAMETER)) {
                        logger.warn("unexpected: " + parameterCursor.getQName());
                        continue;
                    }
                    params.put(parameterCursor.getAttrValue(CoreQName.PARAMETER_KEY), parameterCursor.collectDescendantText(false));
                }
            } while (childCursor.getCurrEvent() != null);
            dctx.pop();
            return table;
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void handleSerialization(SimpleJmTable model, SerializationContext sctx) throws SerializationException {
        Validate.notNull((Object)model);
        Validate.notNull((Object)sctx);
        JiemamyOutputContainer parent = sctx.peek();
        try {
            JiemamyOutputElement element = parent.addElement(CoreQName.TABLE);
            element.addAttribute((JiemamyQName)CoreQName.ID, model.getId());
            element.addElementAndCharacters((JiemamyQName)CoreQName.NAME, model.getName());
            element.addElementAndCharacters((JiemamyQName)CoreQName.LOGICAL_NAME, model.getLogicalName());
            element.addElementAndCharacters((JiemamyQName)CoreQName.DESCRIPTION, model.getDescription());
            sctx.push(element.addElement(CoreQName.COLUMNS));
            for (JmColumn column : model.getColumns()) {
                this.getDirector().direct(column, sctx);
            }
            sctx.pop();
            sctx.push(element.addElement(CoreQName.CONSTRAINTS));
            Set<? extends JmConstraint> constraints = model.getConstraints();
            ArrayList constraintList = Lists.newArrayList(constraints.iterator());
            Collections.sort(constraintList, ConstraintComparator.INSTANCE);
            for (JmConstraint constraint : constraintList) {
                this.getDirector().direct(constraint, sctx);
            }
            sctx.pop();
            ParameterMap params = model.getParams();
            if (params.size() > 0) {
                JiemamyOutputElement paramesElement = element.addElement(CoreQName.PARAMETERS);
                ArrayList paramList = Lists.newArrayList((Iterable)params);
                Collections.sort(paramList, new Comparator<Map.Entry<String, String>>(){

                    @Override
                    public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
                        return e1.getKey().compareTo(e2.getKey());
                    }
                });
                for (Map.Entry entry : paramList) {
                    JiemamyOutputElement paramElement = paramesElement.addElement(CoreQName.PARAMETER);
                    paramElement.addAttribute((JiemamyQName)CoreQName.PARAMETER_KEY, (String)entry.getKey());
                    paramElement.addCharacters((String)entry.getValue());
                }
            }
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }
}

