/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.constraint;

import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.Validate;
import org.codehaus.staxmate.in.SMEvent;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.constraint.JmForeignKeyConstraint;
import org.jiemamy.model.constraint.SimpleJmDeferrability;
import org.jiemamy.model.constraint.SimpleJmForeignKeyConstraint;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.JiemamyCursor;
import org.jiemamy.serializer.stax.JiemamyOutputContainer;
import org.jiemamy.serializer.stax.JiemamyOutputElement;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.xml.CoreQName;
import org.jiemamy.xml.JiemamyQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmForeignKeyConstraintStaxHandler
extends StaxHandler<SimpleJmForeignKeyConstraint> {
    private static Logger logger = LoggerFactory.getLogger(SimpleJmForeignKeyConstraintStaxHandler.class);

    public SimpleJmForeignKeyConstraintStaxHandler(StaxDirector director) {
        super(director);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SimpleJmForeignKeyConstraint handleDeserialization(DeserializationContext dctx) throws SerializationException {
        Validate.notNull((Object)dctx);
        try {
            Validate.isTrue((dctx.peek().getCurrEvent() == SMEvent.START_ELEMENT ? 1 : 0) != 0);
            Validate.isTrue((boolean)dctx.peek().isQName(CoreQName.FOREIGN_KEY));
            JiemamyCursor cursor = dctx.peek();
            String idString = cursor.getAttrValue(CoreQName.ID);
            UUID id = dctx.getContext().toUUID(idString);
            SimpleJmForeignKeyConstraint fk = new SimpleJmForeignKeyConstraint(id);
            JiemamyCursor childCursor = cursor.childElementCursor();
            dctx.push(childCursor);
            do {
                childCursor.advance();
                if (childCursor.getCurrEvent() == SMEvent.START_ELEMENT) {
                    DefaultEntityRef columnRef;
                    String idStr;
                    String text;
                    if (childCursor.isQName(CoreQName.NAME)) {
                        fk.setName(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.LOGICAL_NAME)) {
                        fk.setLogicalName(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.DESCRIPTION)) {
                        fk.setDescription(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.DEFERRABILITY)) {
                        SimpleJmDeferrability deferrability = (SimpleJmDeferrability)this.getDirector().direct(dctx);
                        fk.setDeferrability(deferrability);
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.MATCH_TYPE)) {
                        text = childCursor.collectDescendantText(false);
                        fk.setMatchType(JmForeignKeyConstraint.MatchType.valueOf(text));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.ON_DELETE)) {
                        text = childCursor.collectDescendantText(false);
                        fk.setOnDelete(JmForeignKeyConstraint.ReferentialAction.valueOf(text));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.ON_UPDATE)) {
                        text = childCursor.collectDescendantText(false);
                        fk.setOnDelete(JmForeignKeyConstraint.ReferentialAction.valueOf(text));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.KEY_COLUMNS)) {
                        JiemamyCursor keyColumnsCursor = childCursor.childElementCursor();
                        while (keyColumnsCursor.getNext() != null) {
                            idStr = keyColumnsCursor.getAttrValue(CoreQName.REF);
                            UUID referenceId = dctx.getContext().toUUID(idStr);
                            columnRef = DefaultEntityRef.of((UUID)referenceId);
                            fk.addKeyColumn((EntityRef<? extends JmColumn>)columnRef);
                        }
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.REF_COLUMNS)) {
                        JiemamyCursor refColumnsCursor = childCursor.childElementCursor();
                        while (refColumnsCursor.getNext() != null) {
                            idStr = refColumnsCursor.getAttrValue(CoreQName.REF);
                            UUID refid = dctx.getContext().toUUID(idStr);
                            columnRef = DefaultEntityRef.of((UUID)refid);
                            fk.addReferenceColumn((EntityRef<? extends JmColumn>)columnRef);
                        }
                        continue;
                    } else {
                        logger.warn("UNKNOWN ELEMENT: {}", (Object)childCursor.getQName().toString());
                        continue;
                    }
                }
                if (childCursor.getCurrEvent() == null) continue;
                logger.warn("UNKNOWN EVENT: {}", (Object)childCursor.getCurrEvent());
            } while (childCursor.getCurrEvent() != null);
            dctx.pop();
            return fk;
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void handleSerialization(SimpleJmForeignKeyConstraint model, SerializationContext sctx) throws SerializationException {
        Validate.notNull((Object)model);
        Validate.notNull((Object)sctx);
        JiemamyOutputContainer parent = sctx.peek();
        try {
            JiemamyOutputElement element = parent.addElement(CoreQName.FOREIGN_KEY);
            element.addAttribute((JiemamyQName)CoreQName.ID, model.getId());
            element.addElementAndCharacters((JiemamyQName)CoreQName.NAME, model.getName());
            element.addElementAndCharacters((JiemamyQName)CoreQName.LOGICAL_NAME, model.getLogicalName());
            element.addElementAndCharacters((JiemamyQName)CoreQName.DESCRIPTION, model.getDescription());
            JiemamyOutputElement keyColumnsElement = element.addElement(CoreQName.KEY_COLUMNS);
            for (EntityRef<? extends JmColumn> columnRef : model.getKeyColumns()) {
                keyColumnsElement.addElement(CoreQName.COLUMN_REF).addAttribute((JiemamyQName)CoreQName.REF, columnRef.getReferentId());
            }
            JiemamyOutputElement refColumnsElement = element.addElement(CoreQName.REF_COLUMNS);
            for (EntityRef<? extends JmColumn> columnRef : model.getReferenceColumns()) {
                refColumnsElement.addElement(CoreQName.COLUMN_REF).addAttribute((JiemamyQName)CoreQName.REF, columnRef.getReferentId());
            }
            sctx.push(element);
            if (model.getDeferrability() != null) {
                this.getDirector().direct(model.getDeferrability(), sctx);
            }
            sctx.pop();
            element.addElementAndCharacters((JiemamyQName)CoreQName.MATCH_TYPE, model.getMatchType());
            element.addElementAndCharacters((JiemamyQName)CoreQName.ON_DELETE, model.getOnDelete());
            element.addElementAndCharacters((JiemamyQName)CoreQName.ON_UPDATE, model.getOnUpdate());
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }
}

