/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.visitor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.jiemamy.utils.sql.metadata.TypeSafeResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ForEachUtil {
    public static <T, R, X extends Exception> R accept(Iterable<T> target, CollectionVisitor<T, R, X> visitor) throws X {
        Validate.notNull(target);
        Validate.notNull(visitor);
        for (T element : target) {
            R result = visitor.visit(element);
            if (result == null) continue;
            return result;
        }
        return visitor.getFinalResult();
    }

    public static <K, V, R, X extends Exception> R accept(Map<K, V> targetMap, MapVisitor<K, V, R, X> visitor) throws X {
        Validate.notNull(targetMap);
        Validate.notNull(visitor);
        for (Map.Entry<K, V> entry : targetMap.entrySet()) {
            R result = visitor.visit(entry.getKey(), entry.getValue());
            if (result == null) continue;
            return result;
        }
        return visitor.getFinalResult();
    }

    public static <R, X extends Exception> R accept(ResultSet target, ResultSetVisitor<ResultSet, R, X> visitor) throws SQLException, X {
        Validate.notNull((Object)target);
        Validate.notNull(visitor);
        while (target.next()) {
            visitor.visit(target);
        }
        return visitor.getFinalResult();
    }

    public static <T, R, X extends Exception> R accept(T[] target, CollectionVisitor<T, R, X> visitor) throws X {
        Validate.notNull(target);
        Validate.notNull(visitor);
        for (T element : target) {
            R result = visitor.visit(element);
            if (result == null) continue;
            return result;
        }
        return visitor.getFinalResult();
    }

    public static <T, R, X extends Exception> R accept(TypeSafeResultSet<T> target, TypeSafeResultSetVisitor<T, R, X> visitor) throws SQLException, X {
        Validate.notNull(target);
        Validate.notNull(visitor);
        while (target.next()) {
            visitor.visit(target.getResult());
        }
        return visitor.getFinalResult();
    }

    private ForEachUtil() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TypeSafeResultSetVisitor<T, R, X extends Exception> {
        public R getFinalResult();

        public R visit(T var1) throws SQLException, X;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ResultSetVisitor<T, R, X extends Exception> {
        public R getFinalResult();

        public R visit(T var1) throws SQLException, X;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MapVisitor<K, V, R, X extends Exception> {
        public R getFinalResult();

        public R visit(K var1, V var2) throws X;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CollectionVisitor<T, R, X extends Exception> {
        public R getFinalResult();

        public R visit(T var1) throws X;
    }
}

