/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.validator.impl;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.constraint.JmKeyConstraint;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.utils.EntityToIdTransformer;
import org.jiemamy.validator.AbstractProblem;
import org.jiemamy.validator.AbstractValidator;
import org.jiemamy.validator.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyConstraintValidator
extends AbstractValidator {
    public Collection<Problem> validate(JiemamyContext context) {
        ArrayList problems = Lists.newArrayList();
        for (JmTable table : context.getTables()) {
            List columnIds = Lists.transform(table.getColumns(), (Function)EntityToIdTransformer.INSTANCE);
            for (JmKeyConstraint keyConstraint : table.getConstraints(JmKeyConstraint.class)) {
                if (keyConstraint.getKeyColumns().size() < 1) {
                    problems.add(new NoKeyColumnProblem(table, keyConstraint));
                }
                for (EntityRef<? extends JmColumn> columnRef : keyConstraint.getKeyColumns()) {
                    if (columnIds.contains(columnRef.getReferentId())) continue;
                    problems.add(new IllegalKeyColumnRefProblem(columnRef, keyConstraint, table));
                }
            }
        }
        return problems;
    }

    static class NoKeyColumnProblem
    extends AbstractProblem {
        NoKeyColumnProblem(JmTable table, JmKeyConstraint keyConstraint) {
            super(keyConstraint, "F0140", new Object[]{StringUtils.isEmpty((String)table.getName()) ? table.getId().toString() : table.getName(), keyConstraint.getName()});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IllegalKeyColumnRefProblem
    extends AbstractProblem {
        IllegalKeyColumnRefProblem(EntityRef<? extends JmColumn> columnRef, JmKeyConstraint keyConstraint, JmTable table) {
            super(keyConstraint, "F0130", new Object[]{table.getName(), table.getId().toString(), keyConstraint.getName(), columnRef.getReferentId().toString()});
        }
    }
}

