/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.validator.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jiemamy.JiemamyContext;
import org.jiemamy.model.DbObject;
import org.jiemamy.validator.AbstractProblem;
import org.jiemamy.validator.AbstractValidator;
import org.jiemamy.validator.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbObjectNameCollisionValidator
extends AbstractValidator {
    @Override
    public Collection<? extends Problem> validate(JiemamyContext context) {
        ArrayList problems = Lists.newArrayList();
        HashMap map = Maps.newHashMap();
        for (DbObject dbObject : context.getDbObjects()) {
            String name = dbObject.getName();
            if (!map.containsKey(name)) {
                map.put(name, new ArrayList());
            }
            ((Collection)map.get(name)).add(dbObject);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (((Collection)entry.getValue()).size() == 1) continue;
            problems.add(new DbObjectNameCollisionProblem((String)entry.getKey(), (Collection)entry.getValue()));
        }
        return problems;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DbObjectNameCollisionProblem
    extends AbstractProblem {
        DbObjectNameCollisionProblem(String dbObjectName, Collection<DbObject> dbObjects) {
            super(null, "E0070", new Object[]{dbObjectName});
        }
    }
}

