/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.buri.common.util;

import java.lang.reflect.Field;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.buri.common.util.ClassDefUtil;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.FieldUtil;

public class ClassDefUtilImpl
implements ClassDefUtil {
    public String getClassName(Class clazz) {
        return clazz.getName();
    }

    public String getClassName(Object data) {
        if (data == null) {
            return "";
        }
        Class clazz = this.getClazz(data);
        String className = data.getClass().getName();
        String clazzName = clazz.getName();
        return className;
    }

    public Class getClazz(Object data) {
        if (data == null) {
            return null;
        }
        Class<?> clazz = data.getClass();
        return clazz;
    }

    public Object getMethodSignatureValue(MethodInvocation invoke, String sig, String methodName) {
        String argsName;
        BeanDesc desc = BeanDescFactory.getBeanDesc((Class)this.getClazz(invoke.getThis()));
        if (desc.hasField(argsName = methodName + sig)) {
            Field field = desc.getField(argsName);
            return FieldUtil.get((Field)field, null);
        }
        return null;
    }

    public static boolean isClassName(String className) {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static boolean hasPropertyName(Class tgtClass, String propertyName) {
        String methodName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            tgtClass.getMethod(methodName, new Class[0]);
        }
        catch (SecurityException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }
}

