/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.jiemamy.model.sql.DefaultSqlFormatter;
import org.jiemamy.model.sql.SqlFormatter;
import org.jiemamy.model.sql.SqlStatement;
import org.jiemamy.model.sql.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSqlStatement
implements SqlStatement {
    private final List<Token> tokens;

    public SimpleSqlStatement(List<Token> tokens) {
        Validate.noNullElements(tokens);
        this.tokens = ImmutableList.copyOf(tokens);
    }

    public SimpleSqlStatement(Token token, Token ... tokenArray) {
        Validate.notNull((Object)token);
        Validate.noNullElements((Object[])tokenArray);
        ArrayList tokens = Lists.newArrayList();
        tokens.add(token);
        for (Token tokenRest : tokenArray) {
            tokens.add(tokenRest);
        }
        this.tokens = ImmutableList.copyOf((Iterable)tokens);
    }

    public String toString() {
        return this.toString(new DefaultSqlFormatter());
    }

    public String toString(SqlFormatter formatter) {
        Validate.notNull((Object)formatter);
        return formatter.format((SqlStatement)this);
    }

    public List<Token> toTokens() {
        return Lists.newArrayList(this.tokens);
    }
}

