/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.buri.oouo.internal.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.buri.common.util.ClassDefUtilImpl;
import org.seasar.buri.common.util.StringUtil;
import org.seasar.buri.exception.BuriDataFieldErrorException;
import org.seasar.buri.exception.BuriNoPkeyDefine;
import org.seasar.buri.oouo.internal.structure.BuriExtendedAttributeType;
import org.seasar.framework.log.Logger;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.framework.util.ClassUtil;

public class BuriDataFieldType {
    private static Logger logger = Logger.getLogger((Class)BuriDataFieldType.class);
    private String id;
    private List ExtentedAttribute = new ArrayList();
    private String insert;
    private String update;
    private String select;
    private String delete;
    private String selectMany;
    private String preprocess;
    private String findMany;
    private Map keys = new HashMap();
    public static final String OOUOTHIS = "DataField";
    public static final String setId_ATTRI = "Id";
    public static final String addExtendedAttribute_ELEMENT = "ExtendedAttribute";
    public static final String setupEnd_OOUOFIN = "";

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addExtendedAttribute(BuriExtendedAttributeType attri) {
        this.ExtentedAttribute.add(attri);
    }

    public void setupEnd() {
        Iterator ite = this.ExtentedAttribute.iterator();
        while (ite.hasNext()) {
            BuriExtendedAttributeType attri = (BuriExtendedAttributeType)ite.next();
            String name = attri.getName();
            String value = attri.getValue();
            this.dispach(name, value);
        }
        this.checkError();
    }

    public void checkError() {
        if (this.isErrorString(this.insert)) {
            throw new BuriDataFieldErrorException(this.id, "insert");
        }
        if (this.isErrorString(this.update)) {
            throw new BuriDataFieldErrorException(this.id, "update");
        }
        if (this.isErrorString(this.select)) {
            throw new BuriDataFieldErrorException(this.id, "select");
        }
        if (this.keys.size() == 0 && this.hasDataAccess()) {
            throw new BuriDataFieldErrorException(this.id, "pkey");
        }
        if (this.insert == null && (this.update != null || this.select != null)) {
            throw new BuriDataFieldErrorException(this.id, "insert");
        }
        if (this.update == null && (this.insert != null || this.select != null)) {
            throw new BuriDataFieldErrorException(this.id, "update");
        }
        if (this.select == null && (this.insert != null || this.update != null)) {
            throw new BuriDataFieldErrorException(this.id, "select");
        }
        if (this.selectMany != null && this.keys.size() == 0) {
            throw new BuriDataFieldErrorException(this.id, "pkey,insert,select,update");
        }
        if (!ClassDefUtilImpl.isClassName(this.id)) {
            throw new BuriDataFieldErrorException(this.id);
        }
        if (this.keys.size() > 0) {
            Class tgtClass = ClassUtil.forName((String)this.id);
            Iterator ite = this.keys.keySet().iterator();
            while (ite.hasNext()) {
                String keyVal = ite.next().toString();
                if (ClassDefUtilImpl.hasPropertyName(tgtClass, keyVal)) continue;
                throw new BuriDataFieldErrorException(tgtClass, keyVal);
            }
        }
    }

    private boolean isErrorString(String str) {
        if (this.isNoDefaultUse()) {
            return false;
        }
        return org.seasar.framework.util.StringUtil.isEmpty((String)str);
    }

    private boolean hasDataAccess() {
        return this.insert != null && this.update != null && this.select != null;
    }

    private boolean isNoDefaultUse() {
        if (this.preprocess != null) {
            return true;
        }
        return this.findMany != null;
    }

    private void dispach(String name, String value) {
        if (name.equals("pkey")) {
            this.setupPkey(value);
        } else if (name.equals("insert")) {
            this.insert = value;
        } else if (name.equals("update")) {
            this.update = value;
        } else if (name.equals("select")) {
            this.select = value;
        } else if (name.equals("delete")) {
            this.delete = value;
        } else if (name.equals("selectMany")) {
            this.selectMany = value;
        } else if (name.equals("preprocess")) {
            this.preprocess = value;
        } else if (name.equals("findMany")) {
            this.findMany = value;
        }
    }

    private void setupPkey(String pkey) {
        if (org.seasar.framework.util.StringUtil.isEmpty((String)pkey)) {
            throw new BuriNoPkeyDefine(this.id);
        }
        String[] pkeys = pkey.split("\n");
        if (pkeys.length == 0) {
            throw new BuriNoPkeyDefine(this.id);
        }
        for (int i = 0; i < pkeys.length; ++i) {
            String onePkey = pkeys[i];
            this.setOnePkey(onePkey, this.keys);
        }
    }

    protected void setOnePkey(String onePkey, Map pkeyMap) {
        String[] splitStr = StringUtil.SplitFastString(onePkey, ",");
        String keyName = splitStr[0];
        String keyCheck = keyName + "!=0";
        if (splitStr.length == 0) {
            throw new BuriNoPkeyDefine(this.id, onePkey);
        }
        if (splitStr.length == 1) {
            String msg = MessageFormatter.getMessage((String)"IBRI0001", (Object[])new Object[]{keyName, keyCheck});
            logger.info((Object)msg);
        } else {
            keyCheck = splitStr[1];
        }
        pkeyMap.put(keyName, keyCheck);
    }

    public String getFindMany() {
        return this.findMany;
    }

    public void setFindMany(String findMany) {
        this.findMany = findMany;
    }

    public String getInsert() {
        return this.insert;
    }

    public void setInsert(String insert) {
        this.insert = insert;
    }

    public String getPreprocess() {
        return this.preprocess;
    }

    public void setPreprocess(String preprocess) {
        this.preprocess = preprocess;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public String getSelectMany() {
        return this.selectMany;
    }

    public void setSelectMany(String selectMany) {
        this.selectMany = selectMany;
    }

    public String getUpdate() {
        return this.update;
    }

    public void setUpdate(String update) {
        this.update = update;
    }

    public String getDelete() {
        return this.delete;
    }

    public void setDelete(String delete) {
        this.delete = delete;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("[");
        buff.append("id=").append(this.id);
        buff.append("/ExtentedAttribute=").append(this.ExtentedAttribute);
        buff.append("]");
        return buff.toString();
    }

    public Map getKeys() {
        return this.keys;
    }

    public void setKeys(Map keys) {
        this.keys = keys;
    }
}

