/*
 * Decompiled with CFR 0.152.
 */
package jp.starlogic.servicemanager.impl;

import jp.starlogic.servicemanager.ExecuteService;
import jp.starlogic.servicemanager.OneService;
import jp.starlogic.servicemanager.ServiceMonitor;
import jp.starlogic.servicemanager.exception.ConfigureRuntimeException;
import org.seasar.framework.log.Logger;

public class ExecuteServiceImpl
implements ExecuteService {
    private static Logger logger = Logger.getLogger((Class)ExecuteServiceImpl.class);
    private ServiceMonitor monitor;
    private String serviceName;
    private boolean isTerminate = true;

    public void clear() {
        this.isTerminate = true;
    }

    public void terminate() {
        this.monitor.setTerminate(this.serviceName);
        this.isTerminate = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("terminate " + this.serviceName));
        }
    }

    public void run() {
        this.serviceStartUp();
        OneService service = this.monitor.getOneService(this.serviceName);
        long waitTime = service.getWaitTime();
        long runningTime = service.getRunningTime();
        if (waitTime != 0L) {
            this.runWaitTime(service, waitTime);
        } else if (runningTime != 0L) {
            this.runRunningTime(service, runningTime);
        } else {
            throw new ConfigureRuntimeException("ESVM002");
        }
        this.serviceTerminate();
    }

    protected void serviceStartUp() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("START " + this.serviceName));
        }
        this.monitor.updateStatus(this.serviceName, 1);
    }

    protected void serviceTerminate() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("END " + this.serviceName));
        }
    }

    protected void sleep(long sleeptime) {
        try {
            Thread.sleep(sleeptime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected long getTimeInMillis() {
        return System.currentTimeMillis();
    }

    protected void runWaitTime(OneService service, long waitTime) {
        boolean isNotThrowEx = true;
        this.init(service);
        while (this.isTerminate && (isNotThrowEx = this.processed(service))) {
            this.sleep(waitTime);
        }
        this.destroy(service, isNotThrowEx);
    }

    protected void runRunningTime(OneService service, long runningTime) {
        boolean isNotThrowEx = true;
        this.init(service);
        while (this.isTerminate) {
            long start = this.getTimeInMillis();
            isNotThrowEx = this.processed(service);
            if (!isNotThrowEx) break;
            long processTime = this.getTimeInMillis() - start;
            long waitTime = runningTime - processTime;
            if (logger.isDebugEnabled() && !this.serviceName.equals("StartupService")) {
                logger.debug((Object)("WaitTime(" + this.serviceName + ")=" + waitTime));
            }
            if (waitTime <= 0L) continue;
            this.sleep(waitTime);
        }
        this.destroy(service, isNotThrowEx);
    }

    public void execute(OneService service) {
        if (service.canService()) {
            service.execute();
        }
    }

    protected boolean processed(OneService service) {
        boolean isNotThrowEx = true;
        try {
            this.startExecute();
            this.execute(service);
            this.endExecute();
            this.monitor.updateStatus(this.serviceName, 1);
        }
        catch (Exception ex) {
            logger.fatal((Object)this.serviceName, (Throwable)ex);
            this.monitor.updateStatus(this.serviceName, 2, ex);
            this.terminate();
            isNotThrowEx = false;
            service.abortProcessed();
            this.abortExecute();
        }
        return isNotThrowEx;
    }

    protected void startExecute() {
    }

    protected void endExecute() {
    }

    protected void abortExecute() {
    }

    protected void init(OneService service) {
        service.initService();
    }

    protected void destroy(OneService service, boolean isNotThrowEx) {
        if (isNotThrowEx) {
            if (service.canReExecute()) {
                this.monitor.updateStatus(this.serviceName, 0);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("destroy " + this.serviceName + "/Next Status=WAIT"));
                }
            } else {
                this.monitor.updateStatus(this.serviceName, 2);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("destroy " + this.serviceName + "/Next Status=TERMINATE"));
                }
            }
        }
        service.destroyService();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public ServiceMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(ServiceMonitor monitor) {
        this.monitor = monitor;
    }

    public boolean isTerminate() {
        return this.isTerminate;
    }
}

