/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.dion.h3.sakatsu.addinbox;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;

public class KtHoliday {
    private static HashMap holidayMap = new HashMap();
    private static final Calendar cstImplementTheLawOfHoliday = new GregorianCalendar(1948, 6, 20);
    private static final Calendar cstAkihitoKekkon = new GregorianCalendar(1959, 3, 10);
    private static final Calendar cstShowaTaiso = new GregorianCalendar(1989, 1, 24);
    private static final Calendar cstNorihitoKekkon = new GregorianCalendar(1993, 5, 9);
    private static final Calendar cstSokuireiseiden = new GregorianCalendar(1990, 10, 12);
    private static final Calendar cstImplementHoliday = new GregorianCalendar(1973, 3, 12);

    private KtHoliday() {
    }

    public static String getHolidayName(Calendar prmDate) {
        Long dateID = new Long(prmDate.getTimeInMillis());
        if (holidayMap.containsKey(dateID)) {
            return holidayMap.get(dateID).toString();
        }
        String HolidayName_ret = "";
        Calendar MyDate = Calendar.getInstance();
        MyDate.setTime(prmDate.getTime());
        String HolidayName = KtHoliday.prvHolidayChk(MyDate);
        if (HolidayName.equals("")) {
            if (MyDate.get(7) == 2) {
                if (MyDate.after(cstImplementHoliday) || MyDate.equals(cstImplementHoliday)) {
                    Calendar YesterDay = (Calendar)MyDate.clone();
                    YesterDay.add(5, -1);
                    HolidayName = KtHoliday.prvHolidayChk(YesterDay);
                    HolidayName_ret = "";
                    HolidayName_ret = !HolidayName.equals("") ? "\u632f\u66ff\u4f11\u65e5" : "";
                } else {
                    HolidayName_ret = "";
                }
            } else {
                HolidayName_ret = "";
            }
        } else {
            HolidayName_ret = HolidayName;
        }
        holidayMap.put(dateID, HolidayName_ret);
        return HolidayName_ret;
    }

    private static String prvHolidayChk(Calendar MyDate) {
        int MyYear = MyDate.get(1);
        int MyMonth = MyDate.get(2) + 1;
        int MyDay = MyDate.get(5);
        if (MyDate.before(cstImplementTheLawOfHoliday)) {
            return "";
        }
        String Result = "";
        switch (MyMonth) {
            case 1: {
                if (MyDay == 1) {
                    Result = "\u5143\u65e5";
                    break;
                }
                if (MyYear >= 2000) {
                    int NumberOfWeek = (MyDay - 1) / 7 + 1;
                    if (NumberOfWeek != 2 || MyDate.get(7) != 2) break;
                    Result = "\u6210\u4eba\u306e\u65e5";
                    break;
                }
                if (MyDay != 15) break;
                Result = "\u6210\u4eba\u306e\u65e5";
                break;
            }
            case 2: {
                if (MyDay == 11) {
                    if (MyYear < 1967) break;
                    Result = "\u5efa\u56fd\u8a18\u5ff5\u306e\u65e5";
                    break;
                }
                if (!MyDate.equals(cstShowaTaiso)) break;
                Result = "\u662d\u548c\u5929\u7687\u306e\u5927\u55aa\u306e\u793c";
                break;
            }
            case 3: {
                if (MyDay != KtHoliday.prvDayOfSpringEquinox(MyYear)) break;
                Result = "\u6625\u5206\u306e\u65e5";
                break;
            }
            case 4: {
                if (MyDay == 29) {
                    if (MyYear >= 2007) {
                        Result = "\u662d\u548c\u306e\u65e5";
                        break;
                    }
                    if (MyYear >= 1989) {
                        Result = "\u307f\u3069\u308a\u306e\u65e5";
                        break;
                    }
                    Result = "\u5929\u7687\u8a95\u751f\u65e5";
                    break;
                }
                if (!MyDate.equals(cstAkihitoKekkon)) break;
                Result = "\u7687\u592a\u5b50\u660e\u4ec1\u89aa\u738b\u306e\u7d50\u5a5a\u306e\u5100";
                break;
            }
            case 5: {
                switch (MyDay) {
                    case 3: {
                        Result = "\u61b2\u6cd5\u8a18\u5ff5\u65e5";
                        break;
                    }
                    case 4: {
                        if (MyYear >= 2007) {
                            Result = "\u307f\u3069\u308a\u306e\u65e5";
                            break;
                        }
                        if (MyYear < 1986 || MyDate.get(7) <= 2) break;
                        Result = "\u56fd\u6c11\u306e\u4f11\u65e5";
                        break;
                    }
                    case 5: {
                        Result = "\u3053\u3069\u3082\u306e\u65e5";
                        break;
                    }
                    case 6: {
                        if (MyYear < 2007 || MyDate.get(7) != 3 && MyDate.get(7) != 4) break;
                        Result = "\u632f\u66ff\u4f11\u65e5";
                    }
                }
                break;
            }
            case 6: {
                if (!MyDate.equals(cstNorihitoKekkon)) break;
                Result = "\u7687\u592a\u5b50\u5fb3\u4ec1\u89aa\u738b\u306e\u7d50\u5a5a\u306e\u5100";
                break;
            }
            case 7: {
                if (MyYear >= 2003) {
                    int NumberOfWeek = (MyDay - 1) / 7 + 1;
                    if (NumberOfWeek != 3 || MyDate.get(7) != 2) break;
                    Result = "\u6d77\u306e\u65e5";
                    break;
                }
                if (MyYear < 1996 || MyDay != 20) break;
                Result = "\u6d77\u306e\u65e5";
                break;
            }
            case 9: {
                int MyAutumnEquinox = KtHoliday.prvDayOfAutumnEquinox(MyYear);
                if (MyDay == MyAutumnEquinox) {
                    Result = "\u79cb\u5206\u306e\u65e5";
                    break;
                }
                if (MyYear >= 2003) {
                    int NumberOfWeek = (MyDay - 1) / 7 + 1;
                    if (NumberOfWeek == 3 && MyDate.get(7) == 2) {
                        Result = "\u656c\u8001\u306e\u65e5";
                        break;
                    }
                    if (MyDate.get(7) != 3 || MyDay != MyAutumnEquinox - 1) break;
                    Result = "\u56fd\u6c11\u306e\u4f11\u65e5";
                    break;
                }
                if (MyYear < 1966 || MyDay != 15) break;
                Result = "\u656c\u8001\u306e\u65e5";
                break;
            }
            case 10: {
                if (MyYear >= 2000) {
                    int NumberOfWeek = (MyDay - 1) / 7 + 1;
                    if (NumberOfWeek != 2 || MyDate.get(7) != 2) break;
                    Result = "\u4f53\u80b2\u306e\u65e5";
                    break;
                }
                if (MyYear < 1966 || MyDay != 10) break;
                Result = "\u4f53\u80b2\u306e\u65e5";
                break;
            }
            case 11: {
                if (MyDay == 3) {
                    Result = "\u6587\u5316\u306e\u65e5";
                    break;
                }
                if (MyDay == 23) {
                    Result = "\u52e4\u52b4\u611f\u8b1d\u306e\u65e5";
                    break;
                }
                if (!MyDate.equals(cstSokuireiseiden)) break;
                Result = "\u5373\u4f4d\u793c\u6b63\u6bbf\u306e\u5100";
                break;
            }
            case 12: {
                if (MyDay != 23 || MyYear < 1989) break;
                Result = "\u5929\u7687\u8a95\u751f\u65e5";
            }
        }
        return Result;
    }

    private static int prvDayOfSpringEquinox(int MyYear) {
        int SpringEquinox_ret = MyYear <= 1947 ? 99 : (MyYear <= 1979 ? (int)(20.8357 + 0.242194 * (double)(MyYear - 1980) - (double)((MyYear - 1983) / 4)) : (MyYear <= 2099 ? (int)(20.8431 + 0.242194 * (double)(MyYear - 1980) - (double)((MyYear - 1980) / 4)) : (MyYear <= 2150 ? (int)(21.851 + 0.242194 * (double)(MyYear - 1980) - (double)((MyYear - 1980) / 4)) : 99)));
        return SpringEquinox_ret;
    }

    private static int prvDayOfAutumnEquinox(int MyYear) {
        int AutumnEquinox_ret = MyYear <= 1947 ? 99 : (MyYear <= 1979 ? (int)(23.2588 + 0.242194 * (double)(MyYear - 1980) - (double)((MyYear - 1983) / 4)) : (MyYear <= 2099 ? (int)(23.2488 + 0.242194 * (double)(MyYear - 1980) - (double)((MyYear - 1980) / 4)) : (MyYear <= 2150 ? (int)(24.2488 + 0.242194 * (double)(MyYear - 1980) - (double)((MyYear - 1980) / 4)) : 99)));
        return AutumnEquinox_ret;
    }
}

