/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.dao.pager.LimitOffsetPagingSqlRewriter;

public class MySQLLimitOffsetPagingSqlRewriter
extends LimitOffsetPagingSqlRewriter {
    private static final Pattern baseSqlPattern = Pattern.compile("^.*?(select)", 2);

    String makeLimitOffsetSql(String baseSQL, int limit, int offset) {
        return super.makeLimitOffsetSql(this.makeCalcFoundRowsSQL(baseSQL), limit, offset);
    }

    public MySQLLimitOffsetPagingSqlRewriter() {
        this.countSqlCompatibility = false;
    }

    String makeCountSql(String baseSQL) {
        return "SELECT FOUND_ROWS()";
    }

    String makeCalcFoundRowsSQL(String baseSQL) {
        Matcher matcher = baseSqlPattern.matcher(baseSQL);
        if (matcher.find()) {
            baseSQL = matcher.replaceFirst(matcher.group(1) + " SQL_CALC_FOUND_ROWS");
        }
        return baseSQL;
    }
}

