/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.script;

import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.Validate;
import org.codehaus.staxmate.in.SMEvent;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.script.Position;
import org.jiemamy.model.script.SimpleJmAroundScript;
import org.jiemamy.script.PlainScriptEngine;
import org.jiemamy.script.ScriptString;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.JiemamyCursor;
import org.jiemamy.serializer.stax.JiemamyOutputContainer;
import org.jiemamy.serializer.stax.JiemamyOutputElement;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.utils.UUIDUtil;
import org.jiemamy.xml.CoreQName;
import org.jiemamy.xml.JiemamyQName;
import org.jiemamy.xml.SqlQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmAroundScriptStaxHandler
extends StaxHandler<SimpleJmAroundScript> {
    private static Logger logger = LoggerFactory.getLogger(SimpleJmAroundScriptStaxHandler.class);

    public SimpleJmAroundScriptStaxHandler(StaxDirector director) {
        super(director);
    }

    public SimpleJmAroundScript handleDeserialization(DeserializationContext dctx) throws SerializationException {
        Validate.notNull((Object)dctx);
        try {
            Validate.isTrue((dctx.peek().getCurrEvent() == SMEvent.START_ELEMENT ? 1 : 0) != 0);
            Validate.isTrue((boolean)dctx.peek().isQName((JiemamyQName)SqlQName.AROUND_SCRIPT));
            JiemamyCursor cursor = dctx.peek();
            String idString = cursor.getAttrValue((JiemamyQName)CoreQName.ID);
            UUID id = dctx.getContext().toUUID(idString);
            SimpleJmAroundScript aroundScript = new SimpleJmAroundScript(id);
            JiemamyCursor childCursor = cursor.childElementCursor();
            dctx.push(childCursor);
            do {
                childCursor.advance();
                if (childCursor.getCurrEvent() == SMEvent.START_ELEMENT) {
                    if (childCursor.isQName((JiemamyQName)SqlQName.CORE)) {
                        String coreIdString = childCursor.getAttrValue((JiemamyQName)CoreQName.REF);
                        UUID coreId = UUIDUtil.valueOfOrRandom((String)coreIdString);
                        DefaultEntityRef core = DefaultEntityRef.of((UUID)coreId);
                        aroundScript.setCoreModelRef((EntityRef<? extends DbObject>)core);
                        continue;
                    }
                    if (childCursor.isQName((JiemamyQName)SqlQName.SCRIPT)) {
                        Position position = (Position)childCursor.getAttrEnumValue((JiemamyQName)SqlQName.POSITION, Position.class);
                        String engine = childCursor.hasAttr((JiemamyQName)CoreQName.ENGINE) ? childCursor.getAttrValue((JiemamyQName)CoreQName.ENGINE) : PlainScriptEngine.class.getName();
                        String script = childCursor.collectDescendantText(true);
                        aroundScript.setScript(position, script, engine);
                        continue;
                    }
                    logger.warn("UNKNOWN ELEMENT: {}", (Object)childCursor.getQName().toString());
                    continue;
                }
                if (childCursor.getCurrEvent() == null) continue;
                logger.warn("UNKNOWN EVENT: {}", (Object)childCursor.getCurrEvent());
            } while (childCursor.getCurrEvent() != null);
            dctx.pop();
            return aroundScript;
        }
        catch (XMLStreamException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public void handleSerialization(SimpleJmAroundScript model, SerializationContext sctx) throws SerializationException {
        Validate.notNull((Object)model);
        Validate.notNull((Object)sctx);
        JiemamyOutputContainer parent = sctx.peek();
        try {
            JiemamyOutputElement aroundScriptElement = parent.addElement((JiemamyQName)SqlQName.AROUND_SCRIPT);
            aroundScriptElement.addAttribute((JiemamyQName)CoreQName.ID, (Object)model.getId());
            sctx.push((JiemamyOutputContainer)aroundScriptElement);
            aroundScriptElement.addElement((JiemamyQName)SqlQName.CORE).addAttribute((JiemamyQName)CoreQName.REF, (Object)model.getCoreModelRef().getReferentId());
            for (Map.Entry<Position, ScriptString> e : model.getScriptStrings().entrySet()) {
                ScriptString value = e.getValue();
                JiemamyOutputElement scriptElement = aroundScriptElement.addElement((JiemamyQName)SqlQName.SCRIPT);
                scriptElement.addAttribute((JiemamyQName)SqlQName.POSITION, (Object)e.getKey());
                String scriptEngineClassName = value.getScriptEngineClassName();
                if (!scriptEngineClassName.equals(PlainScriptEngine.class.getName())) {
                    scriptElement.addAttribute((JiemamyQName)CoreQName.ENGINE, scriptEngineClassName);
                }
                scriptElement.addCharacters(value.getScript());
            }
            sctx.pop();
        }
        catch (XMLStreamException e) {
            throw new SerializationException((Throwable)e);
        }
    }
}

