/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.sql.metadata;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeResultSet<T> {
    private final ResultSet resultSet;
    private final Constructor<T> constructor;

    public TypeSafeResultSet(ResultSet resultSet, Class<T> resultClass) {
        Validate.notNull((Object)resultSet);
        Validate.notNull(resultClass);
        this.resultSet = resultSet;
        try {
            this.constructor = resultClass.getConstructor(ResultSet.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("resultClass must have ResultSet constructor.", e);
        }
    }

    public void close() throws SQLException {
        this.resultSet.close();
    }

    public T getResult() throws SQLException {
        try {
            return this.constructor.newInstance(this.resultSet);
        }
        catch (IllegalArgumentException e) {
            throw new JiemamyError("Coding miss.", e);
        }
        catch (InstantiationException e) {
            throw new JiemamyError("resultClass must not be abstract class.", e);
        }
        catch (IllegalAccessException e) {
            throw new JiemamyError("resultClass must have public constructor.", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw new JiemamyError("resultClass construction failed.", e);
        }
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }
}

