/*
 * Decompiled with CFR 0.152.
 */
package org.h2.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.h2.web.FtpServer;

public class FtpData
extends Thread {
    private FtpServer server;
    private InetAddress address;
    private ServerSocket serverSocket;
    private volatile Socket socket;

    public FtpData(FtpServer server, InetAddress address, ServerSocket serverSocket) throws IOException {
        this.server = server;
        this.address = address;
        this.serverSocket = serverSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            FtpData ftpData = this;
            synchronized (ftpData) {
                Socket s = this.serverSocket.accept();
                if (s.getInetAddress().equals(this.address)) {
                    this.server.trace("Data connected:" + s.getInetAddress() + " expected:" + this.address);
                    this.socket = s;
                    this.notifyAll();
                } else {
                    this.server.trace("Data REJECTED:" + s.getInetAddress() + " expected:" + this.address);
                    this.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void waitUntilConnected() {
        while (this.serverSocket != null && this.socket == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void close() {
        this.serverSocket = null;
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(InputStream in) throws IOException {
        this.waitUntilConnected();
        try {
            int len;
            OutputStream out = this.socket.getOutputStream();
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
            out.close();
            this.socket.close();
        }
        finally {
            this.socket.close();
        }
    }

    public synchronized void receive(OutputStream out) throws IOException {
        int len;
        this.waitUntilConnected();
        InputStream in = this.socket.getInputStream();
        byte[] buffer = new byte[4096];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        out.close();
        this.socket.close();
    }
}

