/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import junit.framework.TestCase;
import org.seasar.framework.util.ClassLoaderUtil;

public class ClassLoaderUtilTest
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetClassLoader() throws Exception {
        ClassLoaderUtilTest.assertSame((String)"1", (Object)ClassLoaderUtil.class.getClassLoader(), (Object)ClassLoaderUtil.getClassLoader((Class)Object.class));
        ClassLoaderUtilTest.assertSame((String)"2", (Object)TestCase.class.getClassLoader(), (Object)ClassLoaderUtil.getClassLoader((Class)TestCase.class));
        ClassLoader context = Thread.currentThread().getContextClassLoader();
        try {
            URLClassLoader cl = new URLClassLoader(new URL[0], ((Object)((Object)this)).getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(cl);
            ClassLoaderUtilTest.assertSame((String)"3", (Object)cl, (Object)ClassLoaderUtil.getClassLoader((Class)TestCase.class));
        }
        finally {
            Thread.currentThread().setContextClassLoader(context);
        }
    }

    public void testFindLoadedClass() throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class clazz = ClassLoaderUtil.findLoadedClass((ClassLoader)loader, (String)((Object)((Object)this)).getClass().getName());
        ClassLoaderUtilTest.assertEquals(((Object)((Object)this)).getClass(), (Object)clazz);
    }

    public void testGetResources() throws Exception {
        String name = TestCase.class.getName().replace('.', '/') + ".class";
        Iterator itr = ClassLoaderUtil.getResources(((Object)((Object)this)).getClass(), (String)name);
        ClassLoaderUtilTest.assertNotNull((Object)itr);
        URL url = (URL)itr.next();
        ClassLoaderUtilTest.assertNotNull((Object)url);
    }
}

