/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.message;

import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import junit.framework.TestCase;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.message.MessageResourceBundle;
import org.seasar.framework.message.MessageResourceBundleFacade;
import org.seasar.framework.util.ResourceUtil;

public class MessageResourceBundleFacadeTest
extends TestCase {
    private static final String PATH = "SSRMessages.properties";
    private static final String PATH2 = "SSRMessages_ja.properties";

    public void testCreateProperties_url() throws Exception {
        URL url = ResourceUtil.getResource((String)PATH);
        Properties props = MessageResourceBundleFacade.createProperties((URL)url);
        MessageResourceBundleFacadeTest.assertNotNull((Object)props);
        MessageResourceBundleFacadeTest.assertEquals((Object)"{0} not found", (Object)props.get("ESSR0001"));
    }

    public void testCreateProperties_file() throws Exception {
        File file = ResourceUtil.getResourceAsFile((String)PATH);
        Properties props = MessageResourceBundleFacade.createProperties((File)file);
        MessageResourceBundleFacadeTest.assertNotNull((Object)props);
        MessageResourceBundleFacadeTest.assertEquals((Object)"{0} not found", (Object)props.get("ESSR0001"));
        file = ResourceUtil.getResourceAsFile((String)PATH2);
        props = MessageResourceBundleFacade.createProperties((File)file);
        System.out.println(props.get("ESSR0001"));
        MessageResourceBundleFacadeTest.assertEquals((Object)"{0}\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", (Object)props.get("ESSR0001"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsModified_hot() throws Exception {
        HotdeployUtil.setHotdeploy((boolean)true);
        try {
            URL url = ResourceUtil.getResource((String)PATH);
            File file = ResourceUtil.getFile((URL)url);
            MessageResourceBundleFacade facade = new MessageResourceBundleFacade(url);
            MessageResourceBundleFacadeTest.assertFalse((boolean)facade.isModified());
            Thread.sleep(500L);
            file.setLastModified(new Date().getTime());
            MessageResourceBundleFacadeTest.assertTrue((boolean)facade.isModified());
        }
        finally {
            HotdeployUtil.clearHotdeploy();
        }
    }

    public void testIsModified_cool() throws Exception {
        URL url = ResourceUtil.getResource((String)PATH);
        File file = ResourceUtil.getFile((URL)url);
        MessageResourceBundleFacade facade = new MessageResourceBundleFacade(url);
        MessageResourceBundleFacadeTest.assertFalse((boolean)facade.isModified());
        Thread.sleep(500L);
        file.setLastModified(new Date().getTime());
        MessageResourceBundleFacadeTest.assertFalse((boolean)facade.isModified());
    }

    public void testSetup() throws Exception {
        URL url = ResourceUtil.getResource((String)PATH);
        MessageResourceBundleFacade facade = new MessageResourceBundleFacade(url);
        MessageResourceBundle bundle = facade.getBundle();
        MessageResourceBundleFacadeTest.assertNotNull((Object)bundle);
        MessageResourceBundleFacadeTest.assertEquals((String)"{0} not found", (String)bundle.get("ESSR0001"));
    }

    public void testParent() throws Exception {
        URL url = ResourceUtil.getResource((String)PATH2);
        MessageResourceBundleFacade facade = new MessageResourceBundleFacade(url);
        URL parentUrl = ResourceUtil.getResource((String)PATH);
        MessageResourceBundleFacade parent = new MessageResourceBundleFacade(parentUrl);
        facade.setParent(parent);
        MessageResourceBundle bundle = facade.getBundle();
        MessageResourceBundleFacadeTest.assertNotNull((Object)bundle);
        MessageResourceBundleFacadeTest.assertNotNull((Object)bundle.getParent());
    }
}

