/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Properties;
import junit.framework.TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentDeployer;
import org.seasar.framework.container.PropertyAssembler;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.assembler.AssemblerFactory;
import org.seasar.framework.container.assembler.ManualOnlyPropertyAssembler;
import org.seasar.framework.container.deployer.ComponentDeployerFactory;
import org.seasar.framework.container.deployer.SingletonComponentDeployer;
import org.seasar.framework.container.factory.AbstractS2ContainerBuilder;
import org.seasar.framework.container.factory.CircularIncludeRuntimeException;
import org.seasar.framework.container.factory.ResourceResolver;
import org.seasar.framework.container.factory.S2ContainerBuilder;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.factory.SimplePathResolver;
import org.seasar.framework.container.factory.XmlS2ContainerBuilder;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourceUtil;
import org.xml.sax.SAXException;

public class S2ContainerFactoryTest
extends TestCase {
    static /* synthetic */ Class class$org$seasar$framework$container$factory$S2ContainerFactoryTest;
    static /* synthetic */ Class class$org$seasar$framework$container$factory$S2ContainerFactoryTest$Baz;

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
        S2ContainerFactory.configurationContainer = null;
        S2ContainerFactory.setProvider((S2ContainerFactory.Provider)new S2ContainerFactory.DefaultProvider());
        S2ContainerFactory.setDefaultBuilder((S2ContainerBuilder)new XmlS2ContainerBuilder());
        S2ContainerBehavior.setProvider((S2ContainerBehavior.Provider)new S2ContainerBehavior.DefaultProvider());
        ComponentDeployerFactory.setProvider((ComponentDeployerFactory.Provider)new ComponentDeployerFactory.DefaultProvider());
        AssemblerFactory.setProvider((AssemblerFactory.Provider)new AssemblerFactory.DefaultProvider());
    }

    public void testCircularInclude() throws Exception {
        try {
            S2ContainerFactory.create((String)(((Object)((Object)this)).getClass().getName().replace('.', '/') + ".CircularA.dicon"));
            S2ContainerFactoryTest.fail((String)"1");
        }
        catch (Throwable e) {
            while (e != null) {
                if (e instanceof CircularIncludeRuntimeException) {
                    return;
                }
                e = e instanceof SAXException ? ((SAXException)e).getException() : e.getCause();
            }
            S2ContainerFactoryTest.fail((String)"2");
        }
    }

    public void testCircularInclude2() throws Exception {
        try {
            String path = ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".Circular.dicon";
            S2ContainerFactory.include((S2Container)S2ContainerFactory.create((String)path), (String)path);
            S2ContainerFactoryTest.fail((String)"1");
        }
        catch (Throwable e) {
            while (e != null) {
                if (e instanceof CircularIncludeRuntimeException) {
                    return;
                }
                e = e instanceof SAXException ? ((SAXException)e).getException() : e.getCause();
            }
            S2ContainerFactoryTest.fail((String)"2");
        }
    }

    public void testCircularInclude3() throws Exception {
        try {
            S2ContainerImpl container1 = new S2ContainerImpl();
            container1.setPath("foo");
            S2ContainerImpl container2 = new S2ContainerImpl();
            container2.setPath("bar");
            container1.include((S2Container)container2);
            S2ContainerImpl container3 = new S2ContainerImpl();
            container3.setPath("baz");
            container2.include((S2Container)container3);
            S2ContainerFactory.include((S2Container)container3, (String)"foo");
            S2ContainerFactoryTest.fail((String)"1");
        }
        catch (Throwable e) {
            System.out.println(e);
            while (e != null) {
                if (e instanceof CircularIncludeRuntimeException) {
                    return;
                }
                e = e instanceof SAXException ? ((SAXException)e).getException() : e.getCause();
            }
            S2ContainerFactoryTest.fail((String)"2");
        }
    }

    public void testCustomizeContainerFactory() throws Exception {
        this.configure("ContainerFactory.dicon");
        S2Container container = S2ContainerFactory.create((String)"notExists.dicon");
        S2ContainerFactoryTest.assertNotNull((String)"1", (Object)container);
    }

    public void testCustomizePathResolver() throws Exception {
        this.configure("PathResolver.dicon");
        S2Container container = S2ContainerFactory.create((String)"notExists.dicon");
        S2ContainerFactoryTest.assertNotNull((String)"1", (Object)container);
    }

    public void testCustomizeContainerBuilder() throws Exception {
        this.configure("ContainerBuilder.dicon");
        S2Container container = S2ContainerFactory.create((String)(((Object)((Object)this)).getClass().getName().replace('.', '/') + ".app.properties"));
        container.init();
        S2ContainerFactoryTest.assertNotNull((String)"1", (Object)container.getComponent((Object)"list"));
        S2ContainerFactoryTest.assertNotNull((String)"2", (Object)container.getComponent((Object)"map"));
    }

    public void testCustomizeResourceResolver() throws Exception {
        this.configure("ResourceResolver.dicon");
        S2Container container = S2ContainerFactory.create((String)"hoge.dicon");
        container.init();
        S2ContainerFactoryTest.assertNotNull((String)"1", (Object)container.getComponent((Object)"list"));
        S2ContainerFactoryTest.assertNotNull((String)"2", (Object)container.getComponent((Object)"map"));
    }

    public void testCustomizeContainerBehavior() throws Exception {
        this.configure("ContainerBehavior.dicon");
        S2Container container = S2ContainerFactory.create((String)(((Object)((Object)this)).getClass().getName().replace('.', '/') + ".dicon"));
        container.init();
        S2ContainerFactoryTest.assertNull((String)"1", (Object)container.getComponent((Object)"notFound"));
    }

    public void testCustomizeComponentDeployerFactory() throws Exception {
        this.configure("ComponetDeployerFactory.dicon");
        S2Container container = S2ContainerFactory.create((String)(((Object)((Object)this)).getClass().getName().replace('.', '/') + ".foo.dicon"));
        container.init();
        Bar bar = (Bar)container.getComponent((Object)"bar");
        S2ContainerFactoryTest.assertSame((String)"1", (Object)bar, (Object)container.getComponent((Object)"bar"));
    }

    public void testCustomizeAssemblerFactory() throws Exception {
        this.configure("AssemblerFactory.dicon");
        S2Container container = S2ContainerFactory.create((String)(((Object)((Object)this)).getClass().getName().replace('.', '/') + ".foo.dicon"));
        container.init();
        Baz baz = (Baz)container.getComponent((Object)"baz");
        S2ContainerFactoryTest.assertNull((String)"1", (Object)baz.getFoo());
    }

    public void testCustomizeClassLoader() throws Exception {
        this.configure("ClassLoader.dicon");
        S2Container container = S2ContainerFactory.create((String)(((Object)((Object)this)).getClass().getName().replace('.', '/') + ".foo.dicon"));
        container.init();
        Object baz = container.getComponent((Object)"baz");
        ClassLoader cl = baz.getClass().getClassLoader();
        S2ContainerFactoryTest.assertTrue((String)"1", (boolean)(cl instanceof ChildFirstClassLoader));
        S2ContainerFactoryTest.assertEquals((String)"2", (Object)Thread.currentThread().getContextClassLoader(), (Object)cl.getParent());
    }

    public void testDestroy() throws Exception {
        this.configure("ContainerFactory.dicon");
        S2ContainerFactoryTest.assertNotNull((String)"1", (Object)S2ContainerFactory.configurationContainer);
        S2ContainerFactory.destroy();
        S2ContainerFactoryTest.assertNull((String)"2", (Object)S2ContainerFactory.configurationContainer);
    }

    public void configure(String name) throws Exception {
        String path = ((Object)((Object)this)).getClass().getName().replace('.', '/') + "." + name;
        S2ContainerFactory.configure((String)path);
    }

    public void testInitializeOnCreate() throws Exception {
        Field f = S2ContainerImpl.class.getDeclaredField("inited");
        f.setAccessible(true);
        S2Container container = S2ContainerFactory.create((String)"org/seasar/framework/container/factory/S2ContainerFactoryTest.initializeOnCreate1.dicon");
        S2ContainerFactoryTest.assertFalse((boolean)f.getBoolean(container));
        S2ContainerFactoryTest.assertTrue((boolean)f.getBoolean(container.getChild(0)));
        container = S2ContainerFactory.create((String)"org/seasar/framework/container/factory/S2ContainerFactoryTest.initializeOnCreate2.dicon");
        S2ContainerFactoryTest.assertTrue((boolean)f.getBoolean(container));
    }

    public static class ChildFirstClassLoader
    extends ClassLoader {
        public ChildFirstClassLoader(ClassLoader parent) {
            super(parent);
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (!name.equals((class$org$seasar$framework$container$factory$S2ContainerFactoryTest$Baz == null ? (class$org$seasar$framework$container$factory$S2ContainerFactoryTest$Baz = S2ContainerFactoryTest.class$("org.seasar.framework.container.factory.S2ContainerFactoryTest$Baz")) : class$org$seasar$framework$container$factory$S2ContainerFactoryTest$Baz).getName())) {
                return super.loadClass(name, resolve);
            }
            InputStream is = this.getParent().getResourceAsStream(name.replace('.', '/') + ".class");
            if (is == null) {
                throw new ClassNotFoundException(name);
            }
            try {
                byte[] bytes = new byte[is.available()];
                is.read(bytes);
                Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }

    public static class Baz {
        Foo foo;

        public Foo getFoo() {
            return this.foo;
        }

        public void setFoo(Foo foo) {
            this.foo = foo;
        }
    }

    public static class Bar
    implements Foo {
    }

    public static interface Foo {
    }

    public static class AutoToManualOnlyAssemblerFactory
    extends AssemblerFactory.DefaultProvider {
        public PropertyAssembler createAutoPropertyAssembler(ComponentDef cd) {
            return new ManualOnlyPropertyAssembler(cd);
        }
    }

    public static class PrototypeToSingletonDeployerFactory
    extends ComponentDeployerFactory.DefaultProvider {
        public ComponentDeployer createPrototypeComponentDeployer(ComponentDef cd) {
            return new SingletonComponentDeployer(cd);
        }
    }

    public static class UnthrowExceptionBehavior
    extends S2ContainerBehavior.DefaultProvider {
        public ComponentDef acquireFromGetComponentDef(S2Container container, Object key) {
            return this.getComponentDef(container, key);
        }
    }

    public static class StringResourceResolver
    implements ResourceResolver {
        protected String definition;

        public String getDefinition() {
            return this.definition;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        public InputStream getInputStream(String path) {
            return new ByteArrayInputStream(this.definition.getBytes());
        }
    }

    public static class PropertyBuilder
    extends AbstractS2ContainerBuilder {
        public S2Container build(String path) {
            try {
                S2ContainerImpl container = new S2ContainerImpl();
                Properties props = new Properties();
                props.load(ResourceUtil.getResourceAsStream((String)path));
                Iterator<Object> it = props.keySet().iterator();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    container.register(ClassUtil.forName((String)props.getProperty(name)), name);
                }
                return container;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public S2Container include(S2Container parent, String path) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FixedPathResolver
    extends SimplePathResolver {
        public String resolvePath(String context, String path) {
            return (class$org$seasar$framework$container$factory$S2ContainerFactoryTest == null ? (class$org$seasar$framework$container$factory$S2ContainerFactoryTest = S2ContainerFactoryTest.class$("org.seasar.framework.container.factory.S2ContainerFactoryTest")) : class$org$seasar$framework$container$factory$S2ContainerFactoryTest).getName().replace('.', '/') + ".PathResolver.dicon";
        }
    }

    public static class EmptyContainerFactory
    extends S2ContainerFactory.DefaultProvider {
        public S2Container create(String path) {
            return new S2ContainerImpl();
        }
    }
}

