/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.AspectImpl;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.aop.interceptors.TraceInterceptor;
import org.seasar.framework.aop.proxy.AopProxy;

public class TraceInterceptorTest
extends TestCase {
    public void testIntercept() throws Exception {
        TraceInterceptor interceptor = new TraceInterceptor();
        PointcutImpl pointcut = new PointcutImpl(new String[]{"getTime"});
        AspectImpl aspect = new AspectImpl((MethodInterceptor)interceptor, (Pointcut)pointcut);
        AopProxy aopProxy = new AopProxy(Date.class, new Aspect[]{aspect});
        Date proxy = (Date)aopProxy.create();
        proxy.getTime();
    }

    public void testIntercept2() throws Exception {
        TraceInterceptor interceptor = new TraceInterceptor();
        PointcutImpl pointcut = new PointcutImpl(new String[]{"hoge"});
        AspectImpl aspect = new AspectImpl((MethodInterceptor)interceptor, (Pointcut)pointcut);
        AopProxy aopProxy = new AopProxy(ThrowError.class, new Aspect[]{aspect});
        ThrowError proxy = (ThrowError)aopProxy.create();
        try {
            proxy.hoge();
        }
        catch (Throwable ignore) {
            // empty catch block
        }
    }

    public void testIntercept3() throws Exception {
        TraceInterceptor interceptor = new TraceInterceptor();
        PointcutImpl pointcut = new PointcutImpl(new String[]{"geho"});
        AspectImpl aspect = new AspectImpl((MethodInterceptor)interceptor, (Pointcut)pointcut);
        AopProxy aopProxy = new AopProxy(ThrowError.class, new Aspect[]{aspect});
        ThrowError proxy = (ThrowError)aopProxy.create();
        proxy.geho(new String[0]);
    }

    public void testInterceptArray() throws Exception {
        TraceInterceptor interceptor = new TraceInterceptor();
        PointcutImpl pointcut = new PointcutImpl(new String[]{"hoge"});
        AspectImpl aspect = new AspectImpl((MethodInterceptor)interceptor, (Pointcut)pointcut);
        AopProxy aopProxy = new AopProxy(ArrayHoge.class, new Aspect[]{aspect});
        ArrayHoge proxy = (ArrayHoge)aopProxy.create();
        proxy.hoge(new String[]{"111"});
    }

    public void testInterceptPrimitiveArray() throws Exception {
        TraceInterceptor interceptor = new TraceInterceptor();
        PointcutImpl pointcut = new PointcutImpl(new String[]{"hoge"});
        AspectImpl aspect = new AspectImpl((MethodInterceptor)interceptor, (Pointcut)pointcut);
        AopProxy aopProxy = new AopProxy(ArrayHoge.class, new Aspect[]{aspect});
        ArrayHoge proxy = (ArrayHoge)aopProxy.create();
        proxy.hoge(new int[]{1, 2});
    }

    public void testAppendObject() throws Exception {
        TraceInterceptor interceptor = new TraceInterceptor();
        TraceInterceptorTest.assertEquals((String)"null", (String)interceptor.appendObject(new StringBuffer(), null).toString());
        TraceInterceptorTest.assertEquals((String)"[abc]", (String)interceptor.appendObject(new StringBuffer(), (Object)new Object[]{"abc"}).toString());
        TraceInterceptorTest.assertEquals((String)"[abc, [1], [a, b], [A, B, C]]", (String)interceptor.appendObject(new StringBuffer(), (Object)new Object[]{"abc", new Object[]{"1"}, Arrays.asList("a", "b"), new LinkedHashSet<Object>(Arrays.asList("A", "B", "C"))}).toString());
    }

    public void testAppendArray() throws Exception {
        TraceInterceptor interceptor = new TraceInterceptor();
        TraceInterceptorTest.assertEquals((String)"[[1, 2, 3, 4, 5, 6, 7, 8, 9, 10]]", (String)interceptor.appendObject(new StringBuffer(), (Object)new Object[]{new Object[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"}}).toString());
        interceptor.setMaxLengthOfCollection(11);
        TraceInterceptorTest.assertEquals((String)"[[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]]", (String)interceptor.appendObject(new StringBuffer(), (Object)new Object[]{new Object[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"}}).toString());
        interceptor.setMaxLengthOfCollection(20);
        TraceInterceptorTest.assertEquals((String)"[[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]]", (String)interceptor.appendObject(new StringBuffer(), (Object)new Object[]{new Object[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"}}).toString());
    }

    public static class ArrayHoge {
        public String[] hoge(String[] arg) {
            return new String[]{"aaa", "bbb"};
        }

        public int[] hoge(int[] arg) {
            return new int[]{10, 20};
        }
    }

    public static class ThrowError {
        public void hoge() {
            throw new RuntimeException("hoge");
        }

        public void geho(String[] array) {
        }
    }
}

