/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.math.BigDecimal;
import junit.framework.TestCase;
import org.seasar.framework.util.BigDecimalConversionUtil;

public class BigDecimalConversionUtilTest
extends TestCase {
    private static final BigDecimal ZERO = new BigDecimal("0");

    public void testToBigDecimal() throws Exception {
        BigDecimalConversionUtilTest.assertNull((Object)BigDecimalConversionUtil.toBigDecimal(null));
        BigDecimalConversionUtilTest.assertSame((Object)ZERO, (Object)BigDecimalConversionUtil.toBigDecimal((Object)ZERO));
        BigDecimalConversionUtilTest.assertEquals((Object)new BigDecimal("1"), (Object)BigDecimalConversionUtil.toBigDecimal((Object)new Byte(1)));
        BigDecimalConversionUtilTest.assertEquals((Object)new BigDecimal("10"), (Object)BigDecimalConversionUtil.toBigDecimal((Object)new Short(10)));
        BigDecimalConversionUtilTest.assertEquals((Object)new BigDecimal("100"), (Object)BigDecimalConversionUtil.toBigDecimal((Object)new Integer(100)));
        BigDecimalConversionUtilTest.assertEquals((Object)new BigDecimal("1000"), (Object)BigDecimalConversionUtil.toBigDecimal((Object)new Long(1000L)));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.1").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Float(0.1f))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.1").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(0.1))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.01").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(0.01))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.001").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(0.001))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.0001").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(1.0E-4))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.00001").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(1.0E-5))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.0000001").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(1.0E-7))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.123").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(0.123))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.0123").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(0.0123))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.00123").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(0.00123))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.000123").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(1.23E-4))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.0000123").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(1.23E-5))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.00000123").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(1.23E-6))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.000000123").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(1.23E-7))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.0000000123").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(1.23E-8))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.00000000123").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(1.23E-9))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.000000123").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(1.23E-7))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("1.23E-7").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(1.23E-7))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("1.23E-10").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)new Double(1.23E-10))));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("100.00").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)"100.00")));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("0.000000123").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)"1.23E-7")));
        BigDecimalConversionUtilTest.assertEquals((int)0, (int)new BigDecimal("1.23E-7").compareTo(BigDecimalConversionUtil.toBigDecimal((Object)"0.000000123")));
    }

    public void testToBigDecimalForEmptyString() throws Exception {
        BigDecimalConversionUtilTest.assertNull((Object)BigDecimalConversionUtil.toBigDecimal((Object)""));
    }
}

