/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.seasar.framework.util.ArrayMap;
import org.seasar.framework.util.SerializeUtil;

public class ArrayMapTest
extends TestCase {
    private ArrayMap _map;

    public void testSize() throws Exception {
        ArrayMapTest.assertEquals((String)"1", (int)3, (int)this._map.size());
        this._map.put((Object)"3", (Object)"test3");
        ArrayMapTest.assertEquals((String)"2", (int)4, (int)this._map.size());
    }

    public void testIsEmpty() throws Exception {
        ArrayMapTest.assertTrue((String)"1", (!this._map.isEmpty() ? 1 : 0) != 0);
        this._map.clear();
        ArrayMapTest.assertTrue((String)"2", (boolean)this._map.isEmpty());
    }

    public void testContainsValue() throws Exception {
        ArrayMapTest.assertTrue((String)"1", (boolean)this._map.containsValue((Object)"test2"));
        ArrayMapTest.assertTrue((String)"2", (!this._map.containsValue((Object)"test3") ? 1 : 0) != 0);
    }

    public void testContainsKey() throws Exception {
        ArrayMapTest.assertTrue((String)"1", (boolean)this._map.containsKey((Object)"2"));
        ArrayMapTest.assertTrue((String)"2", (!this._map.containsKey((Object)"3") ? 1 : 0) != 0);
        this._map.put((Object)"3", null);
        ArrayMapTest.assertTrue((String)"3", (boolean)this._map.containsKey((Object)"3"));
    }

    public void testIndexOf() throws Exception {
        ArrayMapTest.assertEquals((String)"1", (int)1, (int)this._map.indexOf((Object)"test"));
        ArrayMapTest.assertEquals((String)"1", (int)0, (int)this._map.indexOf(null));
        ArrayMapTest.assertEquals((String)"2", (int)-1, (int)this._map.indexOf((Object)"test3"));
    }

    public void testGet() throws Exception {
        ArrayMapTest.assertEquals((String)"1", (Object)"test", (Object)this._map.get((Object)"1"));
        ArrayMapTest.assertEquals((String)"2", null, (Object)this._map.get(null));
        ArrayMapTest.assertEquals((String)"3", null, (Object)this._map.get((Object)"test3"));
        ArrayMapTest.assertEquals((String)"4", null, (Object)this._map.get(0));
    }

    public void testPut() throws Exception {
        ArrayMapTest.assertEquals((String)"1", (Object)"test", (Object)this._map.put((Object)"1", (Object)"test3"));
        ArrayMapTest.assertEquals((String)"2", (Object)"test3", (Object)this._map.get((Object)"1"));
        ArrayMapTest.assertEquals((String)"3", (Object)"test3", (Object)this._map.get(1));
        this._map.put(null, (Object)"test4");
        this._map.put(null, (Object)"test5");
    }

    public void testRemove() throws Exception {
        ArrayMapTest.assertEquals((String)"1", (Object)"test", (Object)this._map.remove((Object)"1"));
        ArrayMapTest.assertEquals((String)"2", (int)2, (int)this._map.size());
        ArrayMapTest.assertEquals((String)"3", null, (Object)this._map.remove((Object)"dummy"));
        ArrayMapTest.assertEquals((String)"4", null, (Object)this._map.remove(0));
    }

    public void testRemove2() throws Exception {
        ArrayMap m = new ArrayMap();
        m.put("1", "d");
        m.remove("1");
        ArrayMapTest.assertEquals((String)"1", (boolean)false, (boolean)m.containsKey("1"));
        m.put("1", "d");
        m.remove("1");
        ArrayMapTest.assertEquals((String)"2", (boolean)false, (boolean)m.containsKey("1"));
    }

    public void testRemove3() throws Exception {
        ArrayMap m = new ArrayMap();
        m.put(new MyKey("1"), "d");
        m.put(new MyKey("2"), "d");
        m.remove(new MyKey("1"));
        ArrayMapTest.assertEquals((String)"1", (boolean)false, (boolean)m.containsKey(new MyKey("1")));
    }

    public void testRemove4() throws Exception {
        ArrayMap m = new ArrayMap();
        m.put((Object)"1", (Object)"d");
        m.put((Object)"2", (Object)"d");
        System.out.println("remove before:" + m);
        m.remove((Object)"2");
        System.out.println("remove after:" + m);
        ArrayMapTest.assertEquals((String)"1", (boolean)false, (boolean)m.containsKey((Object)"2"));
        ArrayMapTest.assertEquals((String)"2", (boolean)true, (boolean)m.containsKey((Object)"1"));
        ArrayMapTest.assertEquals((String)"3", (Object)"d", (Object)m.get((Object)"1"));
        ArrayMapTest.assertEquals((String)"4", null, (Object)m.get((Object)"2"));
        ArrayMapTest.assertEquals((String)"5", (Object)"d", (Object)m.get(0));
    }

    public void testPutAll() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("3", "test3");
        m.put("4", "test4");
        this._map.putAll(m);
        ArrayMapTest.assertEquals((String)"1", (Object)"test3", (Object)this._map.get((Object)"3"));
        ArrayMapTest.assertEquals((String)"2", (Object)"test4", (Object)this._map.get((Object)"4"));
        ArrayMapTest.assertEquals((String)"3", (int)5, (int)this._map.size());
    }

    public void testEqaulas() throws Exception {
        ArrayMap copy = (ArrayMap)this._map.clone();
        ArrayMapTest.assertTrue((String)"1", (boolean)this._map.equals((Object)copy));
        ArrayMapTest.assertTrue((String)"2", (!this._map.equals(null) ? 1 : 0) != 0);
        this._map.put((Object)"3", (Object)"test3");
        ArrayMapTest.assertTrue((String)"3", (!this._map.equals((Object)copy) ? 1 : 0) != 0);
    }

    public void testToString() throws Exception {
        ArrayMapTest.assertNotNull((String)"1", (Object)this._map.toString());
    }

    public void testClear() throws Exception {
        this._map.clear();
        ArrayMapTest.assertEquals((String)"1", (int)0, (int)this._map.size());
    }

    public void testEntrySet() throws Exception {
        Iterator i = this._map.entrySet().iterator();
        ArrayMapTest.assertEquals((String)"1", null, ((Map.Entry)i.next()).getKey());
        ArrayMapTest.assertEquals((String)"2", (Object)"1", ((Map.Entry)i.next()).getKey());
        ArrayMapTest.assertEquals((String)"1", (Object)"2", ((Map.Entry)i.next()).getKey());
    }

    public void testSerialize() throws Exception {
        ArrayMap copy = (ArrayMap)SerializeUtil.serialize((Object)this._map);
        ArrayMapTest.assertEquals((String)"1", null, (Object)copy.get(0));
        ArrayMapTest.assertEquals((String)"2", (Object)"test", (Object)copy.get(1));
        ArrayMapTest.assertEquals((String)"3", (Object)"test2", (Object)copy.get(2));
        this._map.equals((Object)copy);
    }

    public void testPerformance() throws Exception {
        int i;
        int num = 100000;
        HashMap hmap = new HashMap();
        ArrayMap amap = new ArrayMap();
        long start = System.currentTimeMillis();
        for (i = 0; i < num; ++i) {
            hmap.put(String.valueOf(i), null);
        }
        System.out.println("HashMap.put:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        for (i = 0; i < num; ++i) {
            amap.put(String.valueOf(i), null);
        }
        System.out.println("ArrayMap.put:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        for (i = 0; i < num; ++i) {
            hmap.get(String.valueOf(i));
        }
        System.out.println("HashMap.get:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        for (i = 0; i < num; ++i) {
            amap.get(String.valueOf(i));
        }
        System.out.println("ArrayMap.get:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        Iterator i2 = hmap.entrySet().iterator();
        while (i2.hasNext()) {
            i2.next();
        }
        System.out.println("HashMap iteration:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        i2 = amap.entrySet().iterator();
        while (i2.hasNext()) {
            i2.next();
        }
        System.out.println("ArrayMap iteration:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        SerializeUtil.serialize(hmap);
        System.out.println("HashMap serialize:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        SerializeUtil.serialize((Object)amap);
        System.out.println("ArrayMap serialize:" + (System.currentTimeMillis() - start));
    }

    protected void setUp() throws Exception {
        this._map = new ArrayMap();
        this._map.put(null, null);
        this._map.put((Object)"1", (Object)"test");
        this._map.put((Object)"2", (Object)"test2");
    }

    protected void tearDown() throws Exception {
        this._map = null;
    }

    private static class MyKey {
        Object _key;

        MyKey(Object key) {
            this._key = key;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof MyKey)) {
                return false;
            }
            return this._key.equals(((MyKey)o)._key);
        }
    }
}

