/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.exception;

import java.sql.SQLException;
import java.util.Locale;
import junit.framework.TestCase;
import org.seasar.framework.exception.SQLRuntimeException;

public class SQLRuntimeExceptionTest
extends TestCase {
    private Locale defaultLocale;

    protected void setUp() throws Exception {
        super.setUp();
        this.defaultLocale = Locale.getDefault();
    }

    protected void tearDown() throws Exception {
        Locale.setDefault(this.defaultLocale);
        super.tearDown();
    }

    public void testErrorMessage_ja() throws Exception {
        Locale.setDefault(Locale.JAPANESE);
        SQLException sqlException = new SQLException("some reason", "fooState", 7650);
        SQLException sqlException2 = new SQLException("hoge reason", "barState", 7660);
        SQLException sqlException3 = new SQLException("fuga reason", "bazState", 7670);
        sqlException.setNextException(sqlException2);
        sqlException2.setNextException(sqlException3);
        SQLRuntimeException sqlRuntimeException = new SQLRuntimeException(sqlException);
        String message = sqlRuntimeException.getMessage();
        System.out.println(message);
        this.assertContains(message, "ErrorCode=7650");
        this.assertContains(message, "SQLState=fooState");
        this.assertContains(message, "some reason");
        this.assertContains(message, "ErrorCode=7660");
        this.assertContains(message, "SQLState=barState");
        this.assertContains(message, "hoge reason");
        this.assertContains(message, "ErrorCode=7670");
        this.assertContains(message, "SQLState=bazState");
        this.assertContains(message, "fuga reason");
    }

    private void assertContains(String s, String contained) {
        SQLRuntimeExceptionTest.assertEquals((String)s, (boolean)true, (s.indexOf(contained) > -1 ? 1 : 0) != 0);
    }

    public void testErrorMessage_en() throws Exception {
        Locale.setDefault(Locale.ENGLISH);
        SQLException sqlException = new SQLException("manyReason", "barState", 1234);
        SQLRuntimeException sqlRuntimeException = new SQLRuntimeException(sqlException);
        String message = sqlRuntimeException.getMessage();
        System.out.println(message);
        this.assertContains(message, "ErrorCode=1234");
        this.assertContains(message, "SQLState=barState");
        this.assertContains(message, "manyReason");
    }
}

