/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import javax.servlet.http.HttpSession;
import org.seasar.framework.unit.S2FrameworkTestCase;

public class RemoveSessionInterceptorTest
extends S2FrameworkTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.include(RemoveSessionInterceptorTest.class.getName().replace('.', '/') + ".dicon");
    }

    public void testSessionExists() throws Exception {
        HttpSession session = this.getRequest().getSession();
        session.setAttribute("foo", (Object)"Foo");
        session.setAttribute("bar", (Object)"Bar");
        session.setAttribute("baz", (Object)"Baz");
        Hoge hoge = (Hoge)this.getComponent("hoge");
        hoge.begin();
        RemoveSessionInterceptorTest.assertEquals((Object)"Foo", (Object)session.getAttribute("foo"));
        RemoveSessionInterceptorTest.assertEquals((Object)"Bar", (Object)session.getAttribute("bar"));
        RemoveSessionInterceptorTest.assertEquals((Object)"Foo", (Object)session.getAttribute("foo"));
        try {
            hoge.fail();
            RemoveSessionInterceptorTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        RemoveSessionInterceptorTest.assertEquals((Object)"Foo", (Object)session.getAttribute("foo"));
        RemoveSessionInterceptorTest.assertEquals((Object)"Bar", (Object)session.getAttribute("bar"));
        RemoveSessionInterceptorTest.assertEquals((Object)"Foo", (Object)session.getAttribute("foo"));
        hoge.end();
        RemoveSessionInterceptorTest.assertEquals((Object)"Foo", (Object)session.getAttribute("foo"));
        RemoveSessionInterceptorTest.assertNull((Object)session.getAttribute("bar"));
        RemoveSessionInterceptorTest.assertEquals((Object)"Foo", (Object)session.getAttribute("foo"));
    }

    public void testSessionNotExists() throws Exception {
        Hoge hoge = (Hoge)this.getComponent("hoge");
        hoge.begin();
        hoge.end();
    }

    public static class Hoge {
        public void begin() {
        }

        public void end() {
        }

        public void fail() {
            throw new RuntimeException();
        }
    }
}

