/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.util.HashMap;
import junit.framework.TestCase;
import org.seasar.framework.util.CaseInsensitiveMap;

public class CaseInsensitiveMapTest
extends TestCase {
    private CaseInsensitiveMap map_;

    public void testContainsKey() throws Exception {
        CaseInsensitiveMapTest.assertTrue((String)"1", (boolean)this.map_.containsKey("ONE"));
        CaseInsensitiveMapTest.assertTrue((String)"2", (boolean)this.map_.containsKey("one"));
        CaseInsensitiveMapTest.assertTrue((String)"3", (!this.map_.containsKey("onex") ? 1 : 0) != 0);
    }

    public void testGet() throws Exception {
        CaseInsensitiveMapTest.assertEquals((String)"1", (Object)"1", (Object)this.map_.get((Object)"ONE"));
        CaseInsensitiveMapTest.assertEquals((String)"2", (Object)"1", (Object)this.map_.get((Object)"One"));
        CaseInsensitiveMapTest.assertEquals((String)"3", null, (Object)this.map_.get((Object)"hoge"));
    }

    public void testPut() throws Exception {
        CaseInsensitiveMapTest.assertEquals((String)"1", (Object)"1", (Object)this.map_.put((Object)"One", (Object)"11"));
        CaseInsensitiveMapTest.assertEquals((String)"2", (Object)"11", (Object)this.map_.get((Object)"one"));
    }

    public void testRemove() throws Exception {
        CaseInsensitiveMapTest.assertEquals((String)"1", (Object)"1", (Object)this.map_.remove((Object)"ONE"));
        CaseInsensitiveMapTest.assertEquals((String)"2", (int)1, (int)this.map_.size());
        CaseInsensitiveMapTest.assertEquals((String)"3", null, (Object)this.map_.remove((Object)"dummy"));
    }

    public void testPutAll() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("three", "3");
        m.put("four", "4");
        this.map_.putAll(m);
        CaseInsensitiveMapTest.assertEquals((String)"1", (Object)"3", (Object)this.map_.get((Object)"THREE"));
        CaseInsensitiveMapTest.assertEquals((String)"2", (Object)"4", (Object)this.map_.get((Object)"FOUR"));
        CaseInsensitiveMapTest.assertEquals((String)"3", (int)4, (int)this.map_.size());
    }

    public void testPerformance() throws Exception {
        for (int j = 0; j < 3; ++j) {
            int i;
            int num = 100000;
            HashMap hmap = new HashMap();
            CaseInsensitiveMap cimap = new CaseInsensitiveMap();
            long start = System.currentTimeMillis();
            for (i = 0; i < num; ++i) {
                hmap.put("a" + String.valueOf(i), null);
            }
            System.out.println("HashMap.put:" + (System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            for (i = 0; i < num; ++i) {
                cimap.put("a" + String.valueOf(i), null);
            }
            System.out.println("CaseInsensitiveMap.put:" + (System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            for (i = 0; i < num; ++i) {
                hmap.get("a" + String.valueOf(i));
            }
            System.out.println("HashMap.get:" + (System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            for (i = 0; i < num; ++i) {
                cimap.get("a" + String.valueOf(i));
            }
            System.out.println("CaseInsensitiveMap.get:" + (System.currentTimeMillis() - start));
        }
    }

    protected void setUp() throws Exception {
        this.map_ = new CaseInsensitiveMap();
        this.map_.put((Object)"one", (Object)"1");
        this.map_.put((Object)"two", (Object)"2");
    }

    protected void tearDown() throws Exception {
        this.map_ = null;
    }
}

